#include <io.h>
#include "timer.h"

static void
servo_out(
	int		servo,
	int		pos
)
{
	time_t start	= time();
	time_t frame	= 11000;
	time_t len	= pos * 8 + 400;

	outp( 1<<servo, PORTE );

	while( time() < start + len )
		;

	outp( 0, PORTE );

	while( time() < start + frame )
		;
}
	

int main( void )
{
	time_init();

	/* Turn port E into the servo output */
	outp( 0xFF, DDRE );
	outp( 0xFF, DDRB );

	while( 1 )
	{
		int i = 0;

		for( ; i < 255 ; i++ )
		{
			time_t end = time() + 10000;
			outp( i, PORTB );

			while( time() < end )
				servo_out( 0, i );
		}

		for( ; i >= 0 ; i-- )
		{
			time_t end = time() + 10000;
			outp( i, PORTB );
			while( time() < end )
				servo_out( 0, i );
		}
	}
}
