/**
 *  $Id: timer.c,v 1.16 2001/11/03 16:15:57 tramm Exp $
 *
 * Access to the RTC and other timer functions.
 */
#include <io.h>
#include <sig-avr.h>
#include "timer.h"


/**
 * Initialize the 16-bit timer to start counting for us.
 * The system clock is 4.0 MHz, which translates to 0.25 microseconds
 * per tick.  If the timer runs at CLK/1, we have a 65536 / 4 = 16 ms
 * time between overflows.
 */
void
time_init( void )
{
	outp( 0x00, TCCR1A );		/* Ignore OC1X */
	outp( 0x01, TCCR1B );		/* Clk / 1 */
	sbi( TIMSK, TOIE1 );		/* Allow interrupts on overflow */
}

volatile uint16_t high_bits;

SIGNAL( SIG_OVERFLOW1 )
{
	high_bits++;
}


/**
 *  usleep( int useconds )
 *
 * Should we check for overflow of end?
 */
void
usleep(
	int			usec
)
{
	time_t end = time() + usec;
	while( time() < end )
		;
}


/**
 *  msleep( int msec ).
 * A long sleep could overflow the 16 bit int's.
 */
void
msleep(
	int			msec
)
{
	while( msec-- > 0 )
		usleep( 1000 );
}

