#ifndef _TIMER_H_
#define _TIMER_H_

/**
 *  $Id: timer.h,v 1.16 2001/11/04 03:16:54 tramm Exp $
 *
 * Access to the timer.  Much of this is inlined to increase
 * the speed of checking the clock.  Sorry for the pollution.
 */

#include <io.h>

#define CPU_SPEED	4000000ul	/* 4.0 Mhz clock */
#define CPU_DIV		1ul		/* Run the sysclock at 1/8 speed */

#ifdef compute_the_scale
# define CLOCK_SCALE	(1000000ul * CPU_DIV / CPU_SPEED)
#else
# define CLOCK_SCALE	1 / 4		/* Faster with only 8 bits... */
#endif


/**
 *  Macros to convert ticks into useconds and back.
 * These use the computed values above to scale.
 */
#define usec2ticks( usec )				\
	((usec) * 4)
#define ticks2usec( ticks )				\
	((ticks) / 4)

typedef uint16_t time_t;

/*
 * Returns the full 16-bit time value.  This counts in ticks
 * since the system was started, which are roughly 0.25 usec each.
 * We don't scale to useconds; the user is required to do that
 * with the ticks2usec macro.
 */
static inline time_t
time( void )
{
	return __inw( TCNT1L );
}

/**
 *  The high_bits are counted on every timer overflow.  They are
 * roughly 1/60th of a second.
 */
extern volatile uint16_t high_bits;

/**
 *  Delay functions
 */
extern void
usleep(
	int		useconds
);

extern void
msleep(
	int		mseconds
);


/**
 *  No tasks, but it does have an init function
 */
extern void
time_init( void );

#endif
