#ifndef _UART_H_
#define _UART_H_

/**
 *  $Id: uart.h,v 1.5 2001/10/25 00:44:49 tramm Exp $
 *
 * Serial port and UART routines
 */

extern int8_t	getchar( uint8_t *c );
extern int8_t	putchar( uint8_t c );
extern void	puts( const char *s );
extern void	putnl( void );
extern void	puthexs( uint8_t i );	/* 2 digits */
extern void	puthex( uint16_t i );	/* 4 digits */
extern void	puthexl( uint32_t i );	/* 8 digits */

extern volatile uint8_t	rx_head, rx_tail;

static inline int8_t
uart_peek( void )
{
	return rx_head != rx_tail;
}


/**
 *  Tasks and initalization
 */
extern void
uart_init( void );

extern void
uart_task( void );


#endif
