	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
/********************************************************************************
	COMPUTATION OF THE FACTOR ORACLE AND THE LRS VALUES	
	This function computes the factor oracle of the word mot of
	length longueur, using suffix links sl.
	It also computes the lrs values.
********************************************************************************/

#include "definitions.h"

void  CompressionFibo(FILE *out, Oracle oracle, Mot mot, Longueur longueur, 
			Etats sl, Lrs lrs, int picture){
	unsigned int i, j, k, p_1, p_2, position_codage, max;

	max = 0;

	i = 1;
	sl[0] = -1;
	lrs[0] = 0;
	position_codage = 0;
	AddBit(out,1);
	if (!picture) AddBit(out,1);
	else AddBit(out,0);
	SendBits(out,longueur,8*sizeof(unsigned int));
	while ( i <= longueur ){
		j = sl[i-1];
		p_1 = i-1;
		while ( j != -1 && 
				!(k = ExisteTransition(oracle, mot, j, mot[i])) ){
			CreerTransition(oracle,j,i);
			p_1 = j;
			j = sl[j];
		}
		if (j == -1) sl[i] = 0;
		else sl[i] = k;
		p_2 = sl[i]-1;
		lrs[i] = LengthRepeatedSuffix(i,sl,p_1,p_2,lrs);
		if (lrs[i]  < i - position_codage)
			EncoderFibo(out, mot, i, sl, lrs, &position_codage);	
		i++;
	}
	if (i-1 != position_codage){
		EncoderFibo(out, mot, i, sl, lrs, &position_codage);
	}
	while (nb_bits != 0) AddBit(out,1);
}

/*************************************************************************
	End of the function
*************************************************************************/
