	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
/********************************************************************************
	COMPUTATION OF THE FACTOR ORACLE AND THE LRS VALUES	
	This function computes the factor oracle of the word mot of
	length longueur, using suffix links sl.
	It also computes the lrs values.
********************************************************************************/

#include "definitions.h"

unsigned int log2(unsigned int valeur){
unsigned int i;

	i = 0;
	while (valeur != 0){
		i++;
		valeur = valeur>>1;
	}
	return i;
}

void TrierLongueurs(FILE *out, Longueur longueur, unsigned int max){
unsigned int indice, max2, nb_triees;

	SendBits(out,nb_longueurs,8*sizeof(unsigned int));

	longueurs_triees = (unsigned int *)calloc(nb_longueurs,sizeof(Lrs));

	nb_triees = 0;
	max2 = 0;
	while (nb_triees < nb_longueurs){
		indice = 0;
		while (indice <= max){
			if (longueurs_codees[indice] >= longueurs_codees[max2])
				max2 = indice;
			indice++;
		}
		longueurs_codees[max2] = 0;
		longueurs_triees[nb_triees] = max2; 
		nb_triees++;
	}
	indice = 0;
	while (indice < nb_longueurs){
		SendBits(out,longueurs_triees[indice],8*sizeof(unsigned int));
		longueurs_codees[longueurs_triees[indice]] = indice;
		//printf("%d %d\n",longueurs_triees[indice],indice);
		indice++;
	}
	free(longueurs_triees);
}

void  CompressionHuffman(FILE *out, Oracle oracle, Mot mot, Longueur longueur, 
			Etats sl, Lrs lrs, int picture){
	unsigned int i, j, k, p_1, p_2, position_codage, max;

	max = 0;

	i = 1;
	sl[0] = -1;
	lrs[0] = 0;
	position_codage = 0;
	AddBit(out,0);
	if (!picture) AddBit(out,1);
        else AddBit(out,0);
	SendBits(out,longueur,8*sizeof(unsigned int));
	while ( i <= longueur ){
		j = sl[i-1];
		p_1 = i-1;
		while ( j != -1 && 
				!(k = ExisteTransition(oracle, mot, j, mot[i])) ){
			CreerTransition(oracle,j,i);
			p_1 = j;
			j = sl[j];
		}
		if (j == -1) sl[i] = 0;
		else sl[i] = k;
		p_2 = sl[i]-1;
		lrs[i] = LengthRepeatedSuffix(i,sl,p_1,p_2,lrs);
		if (lrs[i]  < i - position_codage){
			if (position_codage != i-1){
				if (longueurs_codees[i-1-position_codage] == 0)
					nb_longueurs++;
				longueurs_codees[i-1-position_codage]++;
				if (i-1-position_codage > max) 
					max = i-1-position_codage;
				position_codage = i-1;
			}
			if (lrs[i] == 0) {
				position_codage = i;
				if (longueurs_codees[0] == 0)
					nb_longueurs++;
				longueurs_codees[0]++;
			}
		}
		i++;
	}
	
	if (i-1 != position_codage){
		if (longueurs_codees[i-1-position_codage] == 0)
			nb_longueurs++;
		longueurs_codees[i-1-position_codage]++;
		if (i-1-position_codage > max) 
			max = i-1-position_codage;
		position_codage = i-1;
	}

	TrierLongueurs(out, longueur, max);
	
	i = 1;
	position_codage = 0;
	while (i <= longueur){
		if (lrs[i]  < i - position_codage)
			EncoderHuff(out, mot, longueur, i, sl, lrs, &position_codage);	
		i++;
	}
	if (i-1 != position_codage){
		EncoderHuff(out, mot, longueur, i, sl, lrs, &position_codage);
	}
	while (nb_bits != 0) AddBit(out,1);
}

/*************************************************************************
	End of the function
*************************************************************************/
