	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
/*********************************************************************
	MAIN FUNCTION
	This function reads the words and all the parameters
	from the command line and then runs the computation
	of the repeats.
*********************************************************************/

#include "definitions.h"

int main(int argc, char *argv[]){
Oracle oracle;
Mot mot;
Lrs lrs;
Etats sl;
Longueur longueur;
FILE *in, *out;
struct stat buf;
char *help = "Compror 2.1 (2002)\nUsage: compror option input_file output_file\nOptions:\n\t -c\t compression of input_file into output_file using Fibonacci codes\n\t -ch\t compression of input_file into output_file using Huffman codes\n\t -x\t uncompression of input_file into output_file\n\t -cp\t equal to -c but for pictures\n\t -chp\t equal to -ch but for pictures\n\t -x\t uncompression of input_file into output_file\n";
int i;

	if (argc != 4 && argc != 2){
		printf("Bad number of arguments\nType compror --help\n",help);
		exit(1);
	}
	else if (argc == 2 && strcmp(argv[1],"--help")==0){
		printf("%s",help);
		exit(1);
	}

	if ((in = fopen(argv[2],"r")) == NULL){
		printf("Impossible to open file %s\n",argv[2]);
		exit(1);
	}

	stat(argv[2], &buf);
	longueur = buf.st_size;

	if ((out = fopen(argv[3],"w+")) == NULL){
		printf("Impossible to open file %s\n",argv[3]);
		exit(1);
	}
		
	
	
	init();
	
	if (strcmp(argv[1],"-cp") == 0 || strcmp(argv[1],"-c") == 0 
		|| strcmp(argv[1],"-ch") == 0 || strcmp(argv[1],"-chp") == 0){
		if (strcmp(argv[1],"-cp") == 0 || strcmp(argv[1],"-chp") == 0) 
			i = 2;
		else i = 1;
		mot = (unsigned char *)malloc((longueur*i+1)*sizeof(Mot));
		fread(mot+1,longueur,1,in);
		mot[longueur*i+1] = '\0';
		fclose(in);

		if (strcmp(argv[1],"-cp") == 0 || strcmp(argv[1],"-chp") == 0){ 
			i = longueur;
			longueur = longueur*2;
			while (i > 0){
				mot[2*i] = mot[i]&15;
				mot[2*i-1] = (mot[i]&240)>>4;
				i--;
			}
		}
		oracle = (struct automate*)malloc((longueur+1)*sizeof(Oracle));
		lrs = (unsigned int *)malloc((longueur+1)*sizeof(Lrs));
		longueurs_codees = (unsigned int *)calloc((longueur+1),sizeof(Lrs));
		sl = (unsigned int *)malloc((longueur+1)*sizeof(Etats));
		if (strcmp(argv[1],"-c") == 0 || strcmp(argv[1],"-cp") == 0)
			CompressionFibo(out, oracle, mot, longueur, sl, lrs, i);
		else 
			CompressionHuffman(out, oracle, mot, longueur, sl, lrs, i);
		fclose(out);
		free(longueurs_codees);
		free(lrs);
		free(sl);
	}
	else if (strcmp(argv[1],"-x") == 0){
		mot = (unsigned char *)malloc((longueur+1)*sizeof(Mot));
		fread(mot+1,longueur,1,in);
		fclose(in);
		Decompression(out, mot, longueur);
		fclose(out);
	}
	else {
		printf("Bad option %s\nType compror --help\n",argv[1]);
		exit(1);
	}

	free(mot);

	return 0;
}

/*************************************************************************
	End of the function
*************************************************************************/
