	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
#include "definitions.h"

void Decompression(FILE *out, Mot mot, Longueur longueur){
unsigned int indice, l, i, position, longueur_originale, fin, nbits, type, picture;
unsigned char *output, c;
	
	octet = mot[nb_octets];
	type = GetBit(mot,longueur);
	picture = GetBit(mot,longueur);
	longueur_originale = 
		GetPosition(mot,longueur,8*sizeof(unsigned int));
	if (!type){
		nb_longueurs = 
			GetPosition(mot,longueur,8*sizeof(unsigned int));
		longueurs_codees = 
			(unsigned int *)calloc(nb_longueurs,sizeof(unsigned int));
		indice = 0;
		while (indice < nb_longueurs){
			longueurs_codees[indice] = 
				GetPosition(mot,longueur,8*sizeof(unsigned int));
			indice++;
		}
	}
	output = (unsigned char *)malloc((longueur_originale+1)*sizeof(unsigned char));
	indice = 1;
	 while (indice <= longueur_originale){
		if (type == 1) l = GetLongueurFibo(mot, longueur); 
		else l = GetLongueurHuff(mot, longueur);
		if (l == 0){
			fin = 0;
			while (!fin){
				output[indice] = GetLettre(mot, longueur);
				indice++;
				output[indice] = '\0';
				fin = GetBit(mot, longueur);
			}
		}
		else {
		nbits = log2(indice-1);
			position = GetPosition(mot, longueur, nbits);
			i = 0;
			while (i < l){
				output[indice] = output[position+i];
				indice++;
				output[indice] = '\0';
				i++;
			}
		}
	}
	if (picture){
		i = 1;
		longueur_originale = longueur_originale/2;
		while (i <= longueur_originale){
			output[i] = output[2*i] | (output[2*i-1]<<4);
			i++;
		}
	}
	fwrite(output+1,sizeof(unsigned char),longueur_originale,out);
}
