	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
/*******************************************************************
	FUNCTION TESTING IF A TRANSITION ALREADY EXISTS
	This function returns the state reached by the
	transition from state j and labeled by letter lettre.
	Returns 0 if such a transition does not exist.
*******************************************************************/

#include "definitions.h"

Etat ExisteTransition(Oracle oracle, Mot mot, Etat j, char lettre){
Transitions t;

	t = oracle[j].transitions;
	if (mot[j+1] == lettre) return j+1;
	else while (t != NULL){
			if (mot[t->e] == lettre) return t->e;
			t = t->suivant;
		 }

	return 0;
}

/*************************************************************************
	End of the function
*************************************************************************/
																		 
