	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
#include "definitions.h"

unsigned int GetLongueurFibo(Mot mot, Longueur longueur){
unsigned int bit1, bit2, reste, code_fibo2, indice;

	indice = 1;
	code_fibo2 = 0;
	reste = GetBit(mot, longueur);
	bit1 = GetBit(mot, longueur);
	bit2 = GetBit(mot, longueur);
	while (!bit1 || !bit2){ 
		code_fibo2 += bit1*fibo2[indice];
		bit1 = bit2;
		bit2 = GetBit(mot, longueur);
		indice++;
	}
	code_fibo2 += fibo2[indice];
	if (code_fibo2 == 1 && reste == 0)
		return GetBit(mot, longueur);
	code_fibo2 = 2*code_fibo2 + reste;
	return code_fibo2 - 1;
}
