	/****************************************************
	* Compror: on-line compression with a factor oracle *
	* Version 2.1                                       *
	* Authors: Arnaud Lefebvre and Thierry Lecroq       *
	*          Universite de Rouen, FRANCE              *
	* E-Mail: arnaud.lefebvre@univ-rouen.fr             *
	****************************************************/

/************************************************************************************
        Compror: a new experimental data compression software.
        Copyright (C) 2002  Arnaud Lefebvre and Thierry Lecroq

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version 2
        of the License, or (at your option) any later version.

        This program is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with this program; if not, write to the Free Software
        Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
************************************************************************************/
#include "definitions.h"

void SendLettresFibo(FILE *out, Mot mot, Etat e, Longueur l){
unsigned int i, j;	
unsigned char lettre;
	
	AddBit(out, 0);
	AddBit(out, 1);
	AddBit(out, 1);
	AddBit(out, 0);
	
	i = 0;
	while (i < l){
		lettre = mot[e+i];
		j = 1;
		while (j <= 8){
			AddBit(out,lettre&1);
			lettre = lettre>>1;
			j++;
		}
		i++;
		if (i != l) AddBit(out, 0);
		else AddBit(out, 1);
	}
}
