/*
 *  $Id: version.c,v 1.2 1999/12/01 10:29:02 martin Exp martin $ 
 *
 *  $Log: version.c,v $
 *  Revision 1.2  1999/12/01 10:29:02  martin
 *  Run through indent.
 *
 *  Revision 1.1  1999/11/24 16:33:47  steve
 *  Initial revision
 * 
 *
 */

/* 
 *
 * version returns the version of the driver linked against it
 *
 */

#include <stdio.h>

/*
 *
 * Exclude rarely-used stuff from Windows headers
 *
 */
#ifdef WIN32
# define WIN32_LEAN_AND_MEAN		
# include <windows.h>
#else
# include <unistd.h>
#endif

#include <sql.h>
#include <sqlext.h>

int main(int argc, char *argv[])
{
    SQLRETURN       	retcode;
    SQLHENV         	henv;
    SQLHDBC         	hdbc;
    char                driver_name[128];
    char                driver_ver[128];
    SQLSMALLINT         buffer_len;
	
    /* 
     *
     * Allocate environment handle
     *
     */
	retcode = SQLAllocHandle(			
					SQL_HANDLE_ENV, /* HandleType */ 
					SQL_NULL_HANDLE, /* InputHandle */
					&henv); /* OutputHandlePtr */
    if (!SQL_SUCCEEDED(retcode))
    {
        fprintf(stderr, "Failed to allocate environment handle\n");
        return retcode;
    }
    
    /*
     *
     * Set to ODBC 3.x behaviour 
     *
     */
	retcode = SQLSetEnvAttr(
            henv,                               /* EnvironmentHandle */
            SQL_ATTR_ODBC_VERSION,              /* Attribute */
            (void *) SQL_OV_ODBC3,              /* ValuePtr */
            0);                                 /* StringLength */
	if (!SQL_SUCCEEDED(retcode))
    {
       	fprintf(stderr, "Failed to set ODBC 3.x behaviour\n");
       	return retcode;
    }
	
    /*
     *
     * Allocate connection handle
     *
     */    
	retcode = SQLAllocHandle(
            SQL_HANDLE_DBC,                     /* HandleType */ 
            henv,                               /* InputHandle */
            &hdbc);                             /* OutputHandlePtr */
	if (!SQL_SUCCEEDED(retcode))
    {
       	fprintf(stderr, "Failed to allocate connection handle\n");
       	return retcode;
    }
	
	
    /*
     *
     * Get Driver and Version
     *
     */
	retcode = SQLGetInfo(
            hdbc,                               /* ConnectionHandle */ 
            SQL_DRIVER_NAME,                    /* InfoType */
            driver_name,                        /* InfoValuePtr */
            sizeof(driver_name),                /* BufferLength */
            &buffer_len);                       /* StringLengthPtr */
	if (!SQL_SUCCEEDED(retcode))
    {
       	fprintf(stderr, "Failed to get SQL_DRIVER_NAME\n");
       	return retcode;
    }

	retcode = SQLGetInfo(
            hdbc,                               /* ConnectionHandle */ 
            SQL_DRIVER_VER,                     /* InfoType */
            driver_ver,                         /* InfoValuePtr */
            sizeof(driver_ver),                 /* BufferLength */
            &buffer_len);                       /* StringLengthPtr */
	if (!SQL_SUCCEEDED(retcode))
    {
       	fprintf(stderr, "Failed to get SQL_DRIVER_VER\n");
       	return retcode;
    }

	printf("\n%s %s\n\n", driver_name, driver_ver);

	/*
	 *
	 * Free connection handle
	 *
	 */
	retcode = SQLFreeHandle(
            SQL_HANDLE_DBC,                     /* HandleType */
            hdbc);                              /* Handle */
	if (!SQL_SUCCEEDED(retcode))
   	{
       	fprintf(stderr, "Failed to free connection handle\n");
       	return retcode;
   	}

	/*
	 *
	 * Free environment handle
	 *
	 */
	retcode = SQLFreeHandle(
            SQL_HANDLE_ENV,                     /* HandleType */
            henv);                              /* Handle */
   	if (!SQL_SUCCEEDED(retcode))
   	{
       	fprintf(stderr, "Failed to free environment handle\n");
       	return retcode;
   	}

    return 0;
}



