#!/usr/bin/perl -w
#########################################################
# PerlDesk, www.perldesk.com              RELEASE 1.0.2 #
#                                                       #
# Author: John Bennett	[john@perldesk.com]             #
#                                                       #
#########################################################
# Please direct bug reports, suggestions or feedback	#
# to the perldesk website.                              #
#                                                       #
# PerlDesk is free software, and may be used under the  #
# terms of the GNU General Public License as published  #
# by the Free Software Foundation. For full details of  #
# this license, please see the COPYING file, or visit   #
# www.fsf.org or www.gnu.org                            #
#                                                       #
#########################################################
# Please see the README/INSTALL files if you have       #
# any problems with this software.                      #
#########################################################

$DBHOST = "localhost";
$DBNAME = "database";
$DBUSER = "username";
$DBPASS = "password";


# DATA PATH ##############################################
            # No trailing slash

$data="/path/to/perldesk";


# IMAGE URL ##############################################
            # No trailing slash

$imgbase = 'http://urlto/perldesk/images';


# BASE URL  ##############################################
            # No trailing slash /

$baseurl = "http://urlto/perldesk";


# HELP DESK TITLE ######################################## 

$title="PerlDesk";


# ADMIN EMAIL ############################################

$adminemail = 'demo@perldesk.com';


# EMAIL SUBMISSION #######################################

$ticketad = 'ticket@perldesk.com';

# This address will act as the center point for email 
# control on perldesk. You can still setup multiple email
# addresses, but this will be the address which handles 
# reply emails and email notifications.


# EMAIL TRACKING #######################################

$epre = 'PD';

# This is added to email subjects to track client 
# responses. This must be set on first install and cannot
# be changed once the desk is actively tracking requests.


################### DO NOT EDIT FURTHER ####################
############################################################
#			        									   #
#														   #
#														   #
#                                                          #
############################################################






sub init_global_vars {

# User Templates

$page         = "$data/include/tpl/default.tpl";
$maintpl      = "$data/include/tpl/main.tpl";
$reqtpl       = "$data/include/tpl/submitreq.tpl";
$regtpl       = "$data/include/tpl/register.tpl";
$logtpl       = "$data/include/tpl/login.tpl";
$reg2tpl      = "$data/include/tpl/register2.tpl";
$reg3tpl      = "$data/include/tpl/register3.tpl";
$membermain   = "$data/include/tpl/membermain.tpl";
$emailtpl     = "$data/include/tpl/welcome.txt";
$emailnewtpl  = "$data/include/tpl/newticket.txt";
$viewticket   = "$data/include/tpl/viewticket.tpl";
$profiletml   = "$data/include/tpl/profile.tpl";
$listopentpl  = "$data/include/tpl/list.tpl";
$emailpasstpl = "$data/include/tpl/pass.txt";
$passtml      = "$data/include/tpl/pass.tpl";
$userannounce = "$data/include/tpl/announcement.tpl";
$viewticketclosed ="$data/include/tpl/viewticket_closed.tpl";

# Staff Templates

$staffmain       = "$data/include/tpl/staff/staffmain.tpl";
$staffview       = "$data/include/tpl/staff/viewticket.tpl";
$staffstatus     = "$data/include/tpl/staff/changestatus.tpl";
$staffaddnote    = "$data/include/tpl/staff/staffnote.tpl";
$viewbyuser      = "$data/include/tpl/staff/viewbyuser.tpl";
$emailresponsetpl= "$data/include/tpl/response.txt";
$staffprofiletml = "$data/include/tpl/staff/profile.tpl";
$stafflistcall   = "$data/include/tpl/staff/listcalls.tpl";
$staffsearch     = "$data/include/tpl/staff/search.tpl";
$staffresults    = "$data/include/tpl/staff/search_results.tpl";
$staffannounce   = "$data/include/tpl/staff/announcement.tpl";


# Administration Templates

$adminmain    =  "$data/include/tpl/admin/adminmain.tpl";
$userlist     =  "$data/include/tpl/admin/userlist.tpl";
$userview     =  "$data/include/tpl/admin/userview.tpl";
$userdel      =  "$data/include/tpl/admin/deluser.tpl";
$usercalls    =  "$data/include/tpl/admin/usercalls.tpl";
$edituser     =  "$data/include/tpl/admin/edituser.tpl";
$adminlist    =  "$data/include/tpl/admin/listcalls.tpl";
$stafflist    =  "$data/include/tpl/admin/staff.tpl";
$addstaff     =  "$data/include/tpl/admin/addstaff.tpl";
$emailstaff   =  "$data/include/tpl/admin/emailstaff.tpl";
$adminview    =  "$data/include/tpl/admin/viewcall.tpl";
$adminaddnote =  "$data/include/tpl/admin/actioncall.tpl";
$editstaff    =  "$data/include/tpl/admin/editstaff.tpl";
$adminnotice  =  "$data/include/tpl/admin/anounce.tpl";
$settings     =  "$data/include/tpl/admin/settings.tpl";
$templ        =  "$data/include/tpl/admin/temp.tpl";
$emailusers   =  "$data/include/tpl/admin/emailusers.tpl";
$stats        =  "$data/include/tpl/admin/stats.tpl";
$departments  =  "$data/include/tpl/admin/departments.tpl";
$seestaff     =  "$data/include/tpl/admin/staffview.tpl";
}


$timeoffset = 0;
  @days   = ('Sunday','Monday','Tuesday','Wednesday','Thursday','Friday','Saturday');
  @months = ('January','February','March','April','May','June','July','August','September','October','November','December');
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time + (3600*$timeoffset));
	   	$hour = "0$hour" if ($hour < 10);
		$min  = "0$min" if ($min < 10);
		$sec  = "0$sec" if ($sec < 10);
      if ($hour >= 12) { $variable = "P.M."; }
            else { $variable  = "A.M."; }
      if ($hour == 0) { $hour = 12; }
      if ($hour > 12) { $hour -= 12; }
          $year = 1900 + $year;
	if ($mday eq "1") { $hy = "st"; 
	} elsif ($mday eq "21") { $hy = "st";
	} elsif ($mday eq "31") { $hy = "st"; 
	} elsif ($mday eq "2") { $hy = "nd";
	} elsif ($mday eq "22") { $hy = "nd"; 
	} elsif ($mday eq "3") { $hy = "rd"; 
	} elsif ($mday eq "23") { $hy = "rd";
	} else { $hy = "th"; }
     		$day = $days[$wday];
		$month    = $months[$mon];
		$month_no = ++$mon;
		$date     = "$mday$hy";
		$date_no  = $mday;
		$time     = "$hour:$min:$sec $variable";
		$time_sv  = "$hour:$min $variable";
		$time_var = "$hour:$min:$sec";
		$time_sec = "$hour:$min";

# TIME FORMAT IN PERLDESK

		$hdtime="$date_no-$month_no-$year-$time_sec";



#############################################################