#!/usr/bin/perl
#########################################################
# PerlDesk, www.perldesk.com              RELEASE 1.0.2 #
#                                                       #
# Author: John Bennett	[john@perldesk.com]             #
#                                                       #
#########################################################
# Please direct bug reports, suggestions or feedback	#
# to the perldesk website.                              #
#                                                       #
# PerlDesk is free software, and may be used under the  #
# terms of the GNU General Public License as published  #
# by the Free Software Foundation. For full details of  #
# this license, please see the COPYING file, or visit   #
# www.fsf.org or www.gnu.org                            #
#                                                       #
#########################################################
# Please see the README/INSTALL files if you have       #
# any problems with this software.                      #
#########################################################

BEGIN { require "/path/to/include/conf.pl"; }


use CGI qw(:standard);
use DBI();
 
#########################################################
#                                                       #
# Filename.........: email.pl                           #
# Last Revision....: 12/12/01                           #
# File Version.....: 1.0003                             #
#                                                       #
#########################################################

use MIME::Parser;
use Mail::Address;
use MIME::Entity;
use MIME::Body;
use Data::Dumper;


$parser = new MIME::Parser;

   $parser->ignore_errors(1);
   $parser->output_to_core(1);

  my $MIME_entity = $parser->parse(\*STDIN);
  my $error = ($@ || $parser->last_error);

  $header  = $MIME_entity->head;
  $subject = $header->get('Subject'); 
  $cto     = $header->get('To'); 

  $from = $header->get('From'); 

  @to_addresses   = Mail::Address->parse($cto);
  @from_addresses = Mail::Address->parse($from);

  my $address;


   if (@to_addresses) {
          $to = $to_addresses[0]->address();
    } else {
		exit;
	}

  if (@from_addresses) {
     $address = $from_addresses[0]->address();
    } else {
		exit;
	}

if ($MIME_entity->parts > 0) 
{
  for (my $i=0;$i<$MIME_entity->parts;$i++) 
  {
    my $subEntity = $MIME_entity->parts($i);
    my $ignore_plain = 0;
    my $ignore_html = 0;
    if (($subEntity->mime_type eq 'text/html') &&
        ($ignore_html == 0))  
    {
       if (my $io = $subEntity->open("r"))
       {
           while (defined($_=$io->getline))
              { $_ =~ s/"/\"/g;
				$body .= $_;
			  }
           $io->close;
           $ignore_plain=1;
        }
    }
    if (($subEntity->mime_type eq 'text/plain') &&
         ($ignore_plain=0))  {
       if (my $io = $subEntity->open("r")) {
           while (defined($_=$io->getline))
              { $_ =~ s/"/\"/g;
				$body .= $_;
			  }
           $io->close;
           $ignore_html=1;
        }
     }
  }
}
else 
{
   $body = join "",  @{$MIME_entity->body};
}


   $to = $1 if $to =~ /<(\S+)>/;
   $newfrom = $1 if $from =~ /<(\S+)>/;
   $body =~ s/"/\"/g;

	if ((!$subject) || 
			($subject eq ""))
	 {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
					print MAIL "To: $newfrom\n";
					print MAIL "From: $ticketad\n";
					print MAIL "Subject: Help Desk Response\n\n";
					print MAIL "Please resend your request with a subject line intact, if you ";
					print MAIL "are replying to a staff response, please keep the subject line intact for tracking purposes, if this is a new request, please give it a suitable subject line.";
					print MAIL "\n\n";
					print MAIL "Thank You.";
			close(MAIL);
	exit;
}



$dbh = DBI->connect("DBI:mysql:$DBNAME:localhost","$DBUSER","$DBPASS");



if ($subject =~ /\{$epre-/gi) {

    $callid = $1 if $subject =~ /\{(\S+)\}/;
	$callno = $callid;
	$callno =~ s/$epre-//g;

	$statement = 'SELECT * FROM calls WHERE id = "' . "$callno" . '"'; 
		$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 			$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
		{
			$user      = $ref->{'username'};
			$callemail = $ref->{'email'};
			$status    = $ref->{'status'};
			$category  = $ref->{'category'};
			$subj      = $ref->{'subject'};
		}

	if ($status eq "CLOSED") {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
					print MAIL "To: $newfrom\n";
					print MAIL "From: $ticketad\n";
					print MAIL "Subject: \{$callid\} Help Desk Response\n\n";
					print MAIL "Sorry, you seem to have sent this help desk response to a call which ";
					print MAIL "has already been closed (resolved) by a member of staff.";
					print MAIL "\n\n";
					print MAIL "Thank You.";
			close(MAIL);
	exit;
	}

	if ($callemail != $newfrom) {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
					print MAIL "To: $newfrom\n";
					print MAIL "From: $ticketad\n";
					print MAIL "Subject: \{$callid\} Help Desk Submission\n\n";
					print MAIL "Sorry, you seem to have sent this help desk response to a call which ";
 					print MAIL "is not owned by you. If you believe this to be a mistake, please check ";
					print MAIL "that you are sending this response from the email address used when logging this call.\n\n";
					print MAIL "Thank You.";
			close(MAIL);
	exit;
	}

	$mbody = $dbh->quote($body);

	my $rv = $dbh->do(qq{INSERT INTO notes values (
			"NULL", "0", "1", "NULL", "$callno", "$user", "$hdtime", $mbody)}
	);



 $statement = 'SELECT * FROM staff WHERE access LIKE "%?::%" OR access LIKE "%GLOB::%" OR access="admin"';
        $sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute($category,) or die print "Couldn't execute statement: $DBI::errstr; stopped";
   while(my $ref = $sth->fetchrow_hashref()) {
		if ($ref->{'notify'} eq "1") {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
				print MAIL "To: $ref->{'email'}\n";
				print MAIL "From: $adminemail\n";
				print MAIL "Subject: New Help Desk Response\n\n";
				print MAIL "There is a new email response made by the user in request $callid. \n";
				print MAIL "\nCall Details\n";
				print MAIL "---------------------------------------\n";
				print MAIL "\tResponse by......: $newfrom\n";
				print MAIL "\tCategory.........: $category\n";
				print MAIL "\tSubject..........: $subj\n";
				print MAIL "---------------------------------------\n";
				print MAIL "\n\nThank You.";
			close(MAIL); 
		}
	}
	$sth->finish;
exit;
}

else {

	$statement = 'SELECT * FROM em_forwarders WHERE address = "' . "$to" . '"'; 
		$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 			$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
		{
			$category = $ref->{'category'};
		}




########################################################
# DOES THE EMAIL HAVE TO COME FROM A REGISTERED USER ??
#

	$statement = 'SELECT * FROM settings WHERE setting = "ereqreg"'; 
		$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 			$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
		{
				$requirereg = "$ref->{'value'}";
		}


	if ($requirereg eq "1") {


########################################################
# I REQUIRE REGISTRATION
#

	$statement = 'SELECT * FROM users WHERE email = "' . "$newfrom" . '"'; 
		$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 			$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
		{
				$username = $ref->{'username'};
				$name     = $ref->{'name'}; 
				$email    = $ref->{'email'};
				$url      = $ref->{'url'};
		}
	
		if (!$email) {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
					print MAIL "To: $newfrom\n";
					print MAIL "From: $ticketad\n";
					print MAIL "Subject: Help Desk Submission\n\n";
					print MAIL "Sorry, you do not seem to have an account at the help desk ";
					print MAIL "to submit requests via e-mail you must register. Please visit:\n\n";
					print MAIL "$baseurl/index.pl\n\n";
					print MAIL "Thank You.";
			close(MAIL);
		exit;
		}


	$mbody    = $dbh->quote($body);
	$msubject = $dbh->quote($subject);

	$current_time = time();

	my $rv = $dbh->do(qq{INSERT INTO calls values (
			"NULL", "OPEN", "$username", "$email", "$url", "$name", "3", "$category", $msubject, $mbody, "$hdtime", "Unowned", "NULL", "em", "$current_time", "1")}
	);


	my $trackno = $dbh->{'mysql_insertid'}; 

	notify_techs();

	open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
			print MAIL "To: $newfrom\n";
			print MAIL "From: $ticketad\n";
			print MAIL "Subject: \{$epre-$trackno\} Help Desk Submission\n";
			open (MAILNEWTPL,"$data/include/tpl/newticket.txt");
				while (<MAILNEWTPL>) {
				  if ($_ =~ /\{*\}/i) { 
					s/\{name\}/$name/g;
					s/\{baseurl\}/$baseurl/g;
					s/\{subject\}/$subject/g;
					s/\{description\}/$body/g;
					s/\{date\}/$hdtime/g;					
				  }			
			print MAIL "$_";
			}
	close(MAIL);
	}
 

	elsif ($requirereg eq "0") {

########################################################
# DON'T REQUIRE REGISTRATION - STORE CALL IN DATABASE 

	$statement = 'SELECT * FROM users WHERE email = "' . "$newfrom" . '"'; 
		$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 			$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
		while(my $ref = $sth->fetchrow_hashref()) 
		{
				$username = $ref->{'username'};
				$name     = $ref->{'name'}; 
				$url      = $ref->{'url'};
		}

	if (!$username) { $username = "Unregistered"; 	}
	if (!$name) 	{ $name     = "Unregistered";	}
	if (!$url)		{ $url      = "Unregistered";	}

	$mbody    = $dbh->quote($body);
	$msubject = $dbh->quote($subject);

	$current_time = time();

	my $rv = $dbh->do(qq{INSERT INTO calls values (
			"NULL", "OPEN", "$username", "$newfrom", "$url", "$name", "3", "$category", $msubject, $mbody, "$hdtime", "Unowned", "NULL", "em", "$current_time", "1")}
	);

	notify_techs();

	my $trackno = $dbh->{'mysql_insertid'}; 

	open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
			print MAIL "To: $newfrom\n";
			print MAIL "From: $ticketad\n";
			print MAIL "Subject: \{$epre-$trackno\} Help Desk Submission\n\n";
			open (MAILNEWTPL,"$data/include/tpl/newticket.txt");
				while (<MAILNEWTPL>) {
				  if ($_ =~ /\{*\}/i) { 
		      			s/\{name\}/$name/g;
				    	s/\{subject\}/$subject/g;
				    	s/\{baseurl\}/$baseurl/g;
				    	s/\{description\}/$mbody/g;
				    	s/\{date\}/$hdtime/g;				
				  }			
			print MAIL "$_";
			}
	close(MAIL);
	}
 }

  $parser->filer->purge();

 sub notify_techs {
   $statement = 'SELECT * FROM staff WHERE access LIKE "%' . "$category" . '::%" OR access LIKE "%GLOB::%" OR access="admin"';
        $sth = $dbh->prepare($statement)or die print "Couldn't prepare statement: $DBI::errstr; stopped";
        $sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
   while(my $ref = $sth->fetchrow_hashref()) {
		if ($ref->{'notify'} eq "1") {
			open(MAIL, "|/usr/sbin/sendmail -t") || print "Unable to send mail: $!";
				print MAIL "To: $ref->{'email'}\n";
				print MAIL "From: Help Desk\n";
				print MAIL "Subject: New Help Desk Request\n";
				print MAIL "There is a new help desk submission. \n";
				print MAIL "\nCall Details\n";
				print MAIL "-----------------------------------------\n";
				print MAIL "\tLogged by....: $newfrom\n";
				print MAIL "\tSubject......: $subject\n\n";
				print MAIL "\n";
				print MAIL "-----------------------------------------\n";
				print MAIL "\n\nLogin URL: $baseurl/staff.pl?login\n\n";
				print MAIL "\n\nThank You.";
			close(MAIL); 
		}
	}
	$sth->finish;
}

1;