#!/usr/bin/perl -w
#########################################################
# PerlDesk, www.perldesk.com              RELEASE 1.0.2 #
#                                                       #
# Author: John Bennett	[john@perldesk.com]             #
#                                                       #
#########################################################
# Please direct bug reports, suggestions or feedback	#
# to the perldesk website.                              #
#                                                       #
# PerlDesk is free software, and may be used under the  #
# terms of the GNU General Public License as published  #
# by the Free Software Foundation. For full details of  #
# this license, please see the COPYING file, or visit   #
# www.fsf.org or www.gnu.org                            #
#                                                       #
#########################################################
# Please see the README/INSTALL files if you have       #
# any problems with this software.                      #
#########################################################
#                                                       #
#                    CHECK MODULES                      # 
#                                                       #
#########################################################
# If you are having trouble installing perldesk it may  #
# well be because you are missing some perlmodules.     #
# To find out, simply call this script from your web    #
# browser.                                              #
#########################################################

my @modules = ( 
	'use DBI;', 
	'use MIME::Tools;', 
	'use CGI qw(:standard);', 
	'use MD5;', 
,); 

my $errors = 0; 
print "Content-Type: text/plain\n\n"; 

print qq| <HTML><HEAD><TITLE>PerlDesk Modules Check</TITLE></HEAD><BODY>
          <br><br><div align="center"><font face=Verdana size=3><b>PERLDESK MODULE CHECK</b><br></font><FONT SIZE=2 Face=verdana>($ENV{'SERVER_NAME'})<br><br><br></FONT>
          </div><table wifth="300" align="center"><font face="Verdana" size="2">
		|;

for my $module (@modules) { 	
	eval $module; 
	if($@) { 
		print "<b><font color=red>ERROR</font></b>: $module is missing<br>\n"; 
		$errors++; 
	} 
} 

if(not $errors) { 
	print "Required Modules [ <font color=green><b>OK</b></font> ]<br><br>Your server has all the required modules to run PerlDesk.\n"; 
} 
else { 
	print "<br>Before running this script, please ensure all modules are installed.\n";
} 

print qq| <br><br><br><br><div align="center">Powered by <a href="http://www.perldesk.com">PerlDesk</a></table></font></div></BODY></HTML> |;
