#!/usr/bin/perl -w
#########################################################
# PerlDesk, www.perldesk.com              RELEASE 1.0.2 #
#                                                       #
# Author: John Bennett	[john@perldesk.com]             #
#                                                       #
#########################################################
# Please direct bug reports, suggestions or feedback	#
# to the perldesk website.                              #
#                                                       #
# PerlDesk is free software, and may be used under the  #
# terms of the GNU General Public License as published  #
# by the Free Software Foundation. For full details of  #
# this license, please see the COPYING file, or visit   #
# www.fsf.org or www.gnu.org                            #
#                                                       #
#########################################################
# Please see the README/INSTALL files if you have       #
# any problems with this software.                      #
#########################################################
use CGI qw(:standard);
use DBI();
use MD5 ;

require 'include/lib/cookie.lib';	

BEGIN { require 'staff_subs.pl'; 
		require "include/conf.pl";}

init_global_vars();

#########################################################
#                                                       #
# Filename.........: staff_perf.pl                      #
# Last Revision....: 13/12/01                           #
# File Version.....: 1.0002                             #
#                                                       #
#########################################################
my $q = CGI->new();
check_user();
print "Content-type: text/html\n\n";


  $sth = $dbh->prepare('SELECT COUNT(*) FROM calls WHERE closedby = "' . "$Cookies{'staff'}" . '"' ) or die DBI->errstr;
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
	 my $closed = $sth->fetchrow_array();
	$sth->finish;

  $sth = $dbh->prepare('SELECT COUNT(*) FROM calls WHERE status = "CLOSED"' ) or die DBI->errstr;
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
	 my $total = $sth->fetchrow_array();
	$sth->finish;

  $sth = $dbh->prepare('SELECT COUNT(*) FROM calls') or die DBI->errstr;
	$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
	 my $count = $sth->fetchrow_array();
	$sth->finish;

   if ($closed > 0) {
	$per = ($closed/$total)*100;	
	$perc=sprintf("%.2f",$per);
   } else {
    $perc = "0"
   }

	$statement = 'SELECT responsetime FROM staff WHERE  username = "' . "$Cookies{'staff'}" . '"'; 
	$sth = $dbh->prepare($statement) or die print "Couldn't prepare statement: $DBI::errstr; stopped";
 		$sth->execute() or die print "Couldn't execute statement: $DBI::errstr; stopped";
	    while(my $ref = $sth->fetchrow_hashref()) {	
             $tsec = $ref->{'responsetime'};
        }


 if ($closed > 0) {
   $sec = ($tsec/$closed);
	
   $days    = int($sec/(24*60*60));
   $hours   = ($sec/(60*60))%24;
   $mins    = ($sec/60)%60;
   $secs    = $sec%60;

  $restime = "$hours hr(s) $mins min(s) $secs seconds";
} else {

  $restime = "No calls closed";
 
}

   open (IN, "$data/include/tpl/staff/perf.tpl") ||
				 die "Unable to open: $!";
	while (<IN>) {
			if ($_ =~ /\{*\}/i) {
				s/\{avgresp\}/$restime/i;	
				s/\{perc\}/$perc/i;		
				s/\{closed\}/$closed/i;					
			}
		push (@content, $_);
		} 		
	close (IN);
parse_template();




sub parse_html_code {
	s/\{username\}/$username/g;
	s/\{baseurl\}/$baseurl/g;
	s/\{name\}/$name/g;
	s/\{url\}/$url/g;
	s/\{email\}/$email/g;
}

sub parse_template {
	open (MAIN, "$data/include/tpl/staff/default.tpl") ||
				 die "Unable to open file: Error: $!";
		while (<MAIN>) {
			if (($_ =~ /\{*\}/i) || ($_ =~ /\$title/i) || ($_ =~ /\$baseurl/i) || ($_ =~ /\$imgbase/i)) {
		      s/\$baseurl/$baseurl/g;
s/\$imgbase/$imgbase/g;
		      s/\$title/$title/g;
		      s/\{CONTENT\}/@content/i;
			  s/\{imgbase\}/$imgbase/i;
			} 
			print "$_";
		} #end_while
	close(MAIN);
}
 