
/*
 * Helper functions
 */

void my_usleep(int usec)
{
  struct timeval timeout;
  timeout.tv_sec=0;
  timeout.tv_usec=usec;
  select(0,0,0,0,&timeout);
}

static int my_kill(int pid)
{
  if(!kill(pid, SIGTERM))
  {
    /* we have failed to kill our children twice,
     * sleep on it and try again tomorrow..
     */
    D("killing %d\n",pid);
    my_usleep(4000);
    if(!kill(pid, SIGTERM))
    {
      my_usleep(4000);
      if(!kill(pid, SIGTERM))
      {
	/* We have failed to kill our children a third time -
	 * wield nukes and try again.
	 */
	kill(pid, SIGKILL);
      }
    }
  }
}

/* Check weather there is data to read on 'fd' */
static int data_available(int fd)
{
  fd_set tmp;
  struct timeval timeout;

  do {
    timeout.tv_sec=0;
    timeout.tv_usec=0;
    FD_ZERO(&tmp);
    FD_SET(fd, &tmp);
  } while(select(fd+1, &tmp, 0, 0, &timeout)<0 && errno==EINTR);
  return FD_ISSET(fd, &tmp);
}

static int my_write(int fd, char *buffer, int len)
{
  int written=0;
  while(written < len)
  {
    int i;
    do {
      i=write(fd,buffer + written, len-written);
    } while(i<0 && errno==EINTR);
    if(i<0) return written ? written : i;
    written+=i;
  }
  return written;
}

static int my_read(int fd, char *buffer, int len)
{
  int r=0;
  while(r < len)
  {
    int i;
    do {
      i=read(fd,buffer + r, len-r);
    } while(i<0 && errno==EINTR);
    if(i<0) return r ? r : i;
    r+=i;
  }
  return r;
}
