// mod_auth_smbauth.c
// version 0.0.3
// Brian M. Shire <shire@tekrat.com>

/******************************************************************
* This code is licensed under the GNU Public License(GPL)
* and comes with no warranty!, please read the LICENSE for more
* information
*
* Please note that this code was generated with the Samba project's
* authentication code.  Also note that this is, for the most part,
* a clone of mod_auth_smb, and you should probably be looking at
* that code first as I don't want to take away from what has
* been done on that project. 
*******************************************************************/

// See the README for configuration details...

/**********************************************************************
* Basic Layout of Code...
*  Apache HTTP Includes
*  Module Declaration
*  Methods used for configuration settings
*  Configuration Command Table
*  Authentication Methods
*  Structure for what apache can use in this module
***********************************************************************/

/* Log:
*	03/14/2001: added support for require directive - shire
*	04/09/2001: added ap.note.basic.auth.failure and logging - shire
*	06/14/2001: changed from HTTP_UNAUTHORIZED to DECLINED to allow or other modules - shire
*			-thanks to Gustav for this addition :)
*/  

/* Basic includes for apache module */
#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"
#include "http_main.h"
#include "http_protocol.h"
#include "util_script.h"

/* Variables to hold configuration settings */
int smbauth; 	
char* domain;	
char* pdc;
char* bdc;
int authoritative = 1;

/* Setup our module, see structure at end  */
module mod_auth_smbauth;

/*  Ok, lets declare some methods to read in our configuration commands */
static const char *set_smbauth(cmd_parms *cmd, void *mconfig, int arg) {
	smbauth = arg;
	return NULL;
}
static const char *set_domain(cmd_parms *cmd, void *mconfig, char *arg) {
	domain = arg;
	return NULL;
}
static const char *set_pdc(cmd_parms *cmd, void *mconfig, char *arg) {
	pdc = arg;
	return NULL;
}
static const char *set_bdc(cmd_parms *cmd, void *mconfig, char *arg) {
	bdc = arg;
	return NULL;
}
static const char *set_authoritative(cmd_parms *cmd, void *mconfig, int arg) {
	authoritative = arg;
	return NULL;
}

/* This structure sets up our configuration settings */
static const command_rec smbauth_cmds[] = {
	{ "SMBAuth", set_smbauth, NULL, OR_AUTHCFG, FLAG, "Enable/Disable SMBAuth" },
	{ "SMBAuth_Domain", set_domain, NULL, OR_AUTHCFG, TAKE1, "Domain to authenticate under" },
	{ "SMBAuth_PDC", set_pdc, NULL, OR_AUTHCFG, TAKE1, "Primary Domain Controller (NetBIOS Name)" },
	{ "SMBAuth_BDC", set_bdc, NULL, OR_AUTHCFG, TAKE1, "Backup Domain Controller (NetBIOS Name)" },
	{ "SMBAuth_Authoritative", set_authoritative, NULL, OR_AUTHCFG, FLAG, "Set to off to allow other modules after smbauth to authenticate a user" },
	{NULL}
};

/* Authenticate a user */
int authenticate_user(request_rec *rec) {

	int Valid_User(char*, char*, char*, char*, char*);
	int res;
	const char *pw;

	/* Prompt user for username and password */
	if(res = ap_get_basic_auth_pw(rec, &pw))
		return res;

	/* Authenticate */	
	if(Valid_User(rec->connection->user, (char*)pw, pdc, bdc, domain) == 0)
		return OK;

	if(authoritative) {
		ap_log_printf(rec->server, "Failed Authentication for %s", rec->connection->user);
		ap_note_basic_auth_failure(rec);
		return AUTH_REQUIRED;
	} else {
		return DECLINED;
	}
}

/* Used by require directive to determine if given user is valid */
static int check_user_access(request_rec *r) {
	char *user = r->connection->user;
	int method = r->method_number;
	const char *word, *rqmt;
	const array_header *req_arr = ap_requires(r);
	require_line *req_line;
	int x;

	if(!req_arr) {
		return OK;
	} else {
		req_line = (require_line *) req_arr->elts;
		for(x = 0; x < req_arr->nelts; x++) {
			rqmt = req_line[x].requirement;
			word = ap_getword_white(r->pool, &rqmt);
			if(!strcmp(word, "valid-user")) {
				return OK;
			} else if(!strcmp(word, "user")) {
				while(rqmt[0]) {
					word = ap_getword_conf(r->pool, &rqmt);
					if(!strcmp(user, word)) {
						return OK;
					}
				}
			}
		}
	}

	if(authoritative) {
		ap_note_basic_auth_failure(r);
		return AUTH_REQUIRED;
	} else {
		return DECLINED;
	}
}

/* Module structure for what we support */
module mod_auth_smbauth = {
	STANDARD_MODULE_STUFF,
	NULL,			/* initializer */
	NULL,			/* dir config creater */
	NULL,			/* dir merger -- default is override */
	NULL,			/* server config */
	NULL,			/* merger server config */
	smbauth_cmds,		/* command table */
	NULL,			/* handlers */
	NULL,			/* filename translation */
	authenticate_user,	/* check_user_id */
	NULL,
	check_user_access,	/* check auth */
	NULL,			/* type_checker */
	NULL,			/* fixups */
	NULL,			/* logger */
	NULL,			/* header parser */
	NULL,			/* child_init */
	NULL,			/* child_exit */
	NULL			/* post read_request */
};
