// mod_auth_smbauth.c
// Brian M. Shire <shire@tekrat.com>
// Authenticates jabber users with an NT Domain

#include "jsm.h"

const char *MOD_AUTH_SMBAUTH_PDC = "";
const char *MOD_AUTH_SMBAUTH_BDC = "";

mreturn mod_auth_smbauth_valid(mapi m, void *arg) {
        int Valid_User(char*, char*, char*, char*, char*);
        char *pass;
        char *user;
        if(jpacket_subtype(m->packet) == JPACKET__GET) {
                xmlnode_insert_tag(m->packet->iq,"password");
                return M_PASS;
        }
        // Get the password
        pass = xmlnode_get_tag_data(m->packet->iq, "password");
        if(Valid_User(m->user->id->user, pass, "dac", MOD_AUTH_SMBAUTH_PDC, MOD_AUTH_SMBAUTH_BDC) == 0) {
                jutil_iqresult(m->packet->x);
        } else {
                jutil_error(m->packet->x, TERROR_AUTH);
        }
        return M_HANDLED;
}

mreturn mod_auth_smbauth_register(mapi m, void *arg)
{
    xmlnode q, reg, xp;
    if((reg = js_config(m->si, "register")) == NULL) return M_PASS;
    log_debug("mod_register","checking");
    switch(jpacket_subtype(m->packet))
    {
    case JPACKET__GET:
        /* create reply to the get */
        jutil_iqresult(m->packet->x);
        /* create a new query */
        q = xmlnode_insert_tag(m->packet->x, "query");
        xmlnode_put_attrib(q,"xmlns",NS_REGISTER);
        /* copy in the registration fields from the config file */
        xmlnode_insert_node(q,xmlnode_get_firstchild(reg));
        break;
    case JPACKET__SET:
        log_debug(ZONE,"processing valid registration for %s",jid_full(m->packet->to));
        /* don't save the auth data ;) */
        xp = xmlnode_new_tag("password");
        if(xdb_set(m->si->xc, jid_user(m->packet->to), NS_AUTH, xp))
        /* try to save the auth data */
//        if(xdb_set(m->si->xc, jid_user(m->packet->to), NS_AUTH, xmlnode_get_tag(m->packet->iq,"password")))
        {
            jutil_error(m->packet->x, TERROR_FORBIDDEN); /* or 503? */
            break;
        }
        /* save the registration data */
        xmlnode_hide(xmlnode_get_tag(m->packet->iq,"password")); /* hide the username/password from the reg db */
        xmlnode_hide(xmlnode_get_tag(m->packet->iq,"username"));
        jutil_delay(m->packet->iq,"registered");
        xdb_set(m->si->xc, jid_user(m->packet->to), NS_REGISTER, m->packet->iq);
        /* if configured to, send admins a notice */
        if(xmlnode_get_attrib(reg,"notify") != NULL)
        {
            q = jutil_msgnew(NULL,
                m->packet->to->server,
                "Registration Notice",
                spools(m->packet->p,"The user ",jid_full(m->packet->to)," was just created with the following registration data: ",xmlnode2str(m->packet->iq),m->packet->p));
            xmlnode_put_attrib(q, "from", m->packet->to->server);
            js_deliver(m->si,jpacket_new(q));
        }
        /* if also configured, send the new user a welcome message */
        if((reg = js_config(m->si, "welcome")) != NULL)
        {
            q = xmlnode_new_tag("message");
            xmlnode_put_attrib(q, "from", m->packet->to->server);
            xmlnode_put_attrib(q, "to", jid_full(m->packet->to));
            xmlnode_insert_node(q, xmlnode_get_firstchild(reg));
            js_deliver(m->si,jpacket_new(q));
        }
        /* clean up and respond */
        jutil_iqresult(m->packet->x);
        break;
    default:
        return M_PASS;
    }
    return M_HANDLED;
}

void mod_auth_smbauth(jsmi si) {
        log_debug("mod_auth_smbauth", "init");
        js_mapi_register(si, e_AUTH, mod_auth_smbauth_valid, NULL);
        js_mapi_register(si, e_REGISTER, mod_auth_smbauth_register, NULL);
}

