/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors:                                                             |
   |                                                                      |
   +----------------------------------------------------------------------+
 */

#ifndef PHP_SMBAUTH_H
#define PHP_SMBAUTH_H

extern zend_module_entry smbauth_module_entry;
#define phpext_smbauth_ptr &smbauth_module_entry

#ifdef PHP_WIN32
#define PHP_SMBAUTH_API __declspec(dllexport)
#else
#define PHP_SMBAUTH_API
#endif

PHP_MINIT_FUNCTION(smbauth);
PHP_MSHUTDOWN_FUNCTION(smbauth);
PHP_RINIT_FUNCTION(smbauth);
PHP_RSHUTDOWN_FUNCTION(smbauth);
PHP_MINFO_FUNCTION(smbauth);

PHP_FUNCTION(smbauth_validate);	
PHP_FUNCTION(smbauth_error);	

/* 
  	Declare any global variables you may need between the BEGIN
	and END macros here:     

ZEND_BEGIN_MODULE_GLOBALS(smbauth)
	int global_variable;
ZEND_END_MODULE_GLOBALS(smbauth)
*/

/* In every function that needs to use variables in php_smbauth_globals,
   do call SMBAUTHLS_FETCH(); after declaring other variables used by
   that function, and always refer to them as SMBAUTHG(variable).
   You are encouraged to rename these macros something shorter, see
   examples in any other php module directory.
*/

#ifdef ZTS
#define SMBAUTHG(v) (smbauth_globals->v)
#define SMBAUTHLS_FETCH() php_smbauth_globals *smbauth_globals = ts_resource(smbauth_globals_id)
#else
#define SMBAUTHG(v) (smbauth_globals.v)
#define SMBAUTHLS_FETCH()
#endif

#endif	/* PHP_SMBAUTH_H */


/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
