/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors:                                                             |
   |                                                                      |
   +----------------------------------------------------------------------+
 */

#include "php.h"
#include "php_ini.h"
#include "php_smbauth.h"

/* If you declare any globals in php_smbauth.h uncomment this:
ZEND_DECLARE_MODULE_GLOBALS(smbauth)
*/

DLEXPORT zend_module_entry *get_module() { return &smbauth_module_entry; }

/* True global resources - no need for thread safety here */
static int le_smbauth;

/* Every user visible function must have an entry in smbauth_functions[].
*/
function_entry smbauth_functions[] = {
	PHP_FE(smbauth_validate,	NULL)		/* For testing, remove later. */
	PHP_FE(smbauth_error,	NULL)		/* For testing, remove later. */
	{NULL, NULL, NULL}	/* Must be the last line in smbauth_functions[] */
};

zend_module_entry smbauth_module_entry = {
	"smbauth",
	smbauth_functions,
	PHP_MINIT(smbauth),
	PHP_MSHUTDOWN(smbauth),
	PHP_RINIT(smbauth),		/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(smbauth),	/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(smbauth),
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_SMBAUTH
ZEND_GET_MODULE(smbauth)
#endif

/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
PHP_INI_END()
*/

PHP_MINIT_FUNCTION(smbauth)
{
/* Remove comments if you have entries in php.ini
	REGISTER_INI_ENTRIES();
*/
	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(smbauth)
{
/* Remove comments if you have entries in php.ini
	UNREGISTER_INI_ENTRIES();
*/
	return SUCCESS;
}

/* Remove if there's nothing to do at request start */
PHP_RINIT_FUNCTION(smbauth)
{
	return SUCCESS;
}

/* Remove if there's nothing to do at request end */
PHP_RSHUTDOWN_FUNCTION(smbauth)
{
	return SUCCESS;
}

PHP_MINFO_FUNCTION(smbauth)
{
	php_info_print_table_start();
	php_info_print_table_header(2, "smbauth support", "enabled");
	php_info_print_table_end();

	/* Remove comments if you have entries in php.ini
	DISPLAY_INI_ENTRIES();
	*/
}

/* Remove the following function when you have succesfully modified config.m4
   so that your module can be compiled into PHP, it exists only for testing
   purposes. */

/* {{{ proto long smbauth_validate(string user, string pass, string pdc, string bdc, string domain)
	Returns 0 on success or 1,2,3 on failure */
PHP_FUNCTION(smbauth_validate)
{
	int Valid_User(char*, char*, char*, char*, char*);
	zval **user_arg, **pass_arg, **pdc_arg, **bdc_arg, **domain_arg;
	char *user, *pass, *pdc, *bdc, *domain;
	int rval;

	if (ZEND_NUM_ARGS() != 5 || zend_get_parameters_ex(5, &user_arg, &pass_arg, &pdc_arg, &bdc_arg, &domain_arg) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	convert_to_string_ex(user_arg);
	convert_to_string_ex(pass_arg);
	convert_to_string_ex(pdc_arg);
	convert_to_string_ex(bdc_arg);
	convert_to_string_ex(domain_arg);

	user = (*user_arg)->value.str.val;
	pass = (*pass_arg)->value.str.val;
	pdc = (*pdc_arg)->value.str.val;
	bdc = (*bdc_arg)->value.str.val;
	domain = (*domain_arg)->value.str.val;

	rval = Valid_User(user, pass, pdc, bdc, domain);

	RETURN_LONG((long)rval);
}
/* }}} */

/* {{{ proto string php_error(long errorcode)
   Return a string description of the error code returned by smbauth_validate */
PHP_FUNCTION(smbauth_error)
{
	zval **arg;
	long err;
	char *rval;

	if(ZEND_NUM_ARGS() != 1 || zend_get_parameters_ex(1, &arg) == FAILURE) {
		WRONG_PARAM_COUNT;
	}

	convert_to_long_ex(arg);
	err = (*arg)->value.lval;

	if(&err == 0) {
		rval = "No Error(0)";
	} else if(err == 1) {
		rval = "Server Error(1)";
	} else if(err == 2) {
		rval = "Protocol Error(2)";
	} else if(err == 3) {
		rval = "Logon Error(3)";
	} else {
		rval = "Error code not recognized";
	}

	RETURN_STRINGL(rval, strlen(rval), 1);	
}
/* }}} */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
