// smbauthmodule.c
// Brian M. Shire <shire@tekrat.com>
// Python Module for authenticating a user with a SMB Server

#include <Python.h>

static PyObject *smbauth_authenticate(PyObject *self, PyObject *args) {
	char *domain, *pdc, *bdc, *user, *pass;
	int res;
	int Valid_User(char *user, char *pass, char *pdc, char *bdc, char *domain);

	if(!PyArg_ParseTuple(args, "sssss", &user, &pass, &pdc, &bdc, &domain))
		return NULL;

	res = Valid_User(user, pass, pdc, bdc, domain);	
	return Py_BuildValue("i", res);
} 

static PyObject *smbauth_getError(PyObject *self, PyObject *args) {
	int err;
	if(!PyArg_ParseTuple(args, "i", &err))
		return NULL;
	return Py_BuildValue("s", err2string(err));
}

static PyMethodDef smbauthMethods[] = {
	{"authenticate", smbauth_authenticate, METH_VARARGS},
	{"getError", smbauth_getError, METH_VARARGS},
	{NULL, NULL}
};

void initsmbauth() {
	(void) Py_InitModule("smbauth", smbauthMethods);
}
