// smbauth.c
// Brian M. Shire <shire@tekrat.com>
// Built to authenticate users with the NT Domain controller
// Accepts a password as an environment variable or prompt.
/* Log:
*	02/22/2001:shire: Initial Creation
*	03/02/2001:shire: Re-Built from pam_smb-1.1.6
*	03/02/2001:shire: Ability to prompt for password, or use env. vars.
*	06/14/2001:shire: Fixed Seg Fault if ENV variable isn't set.
*	08/02/2001:shire: Increased user/pass length to 20
*			  Added general error code responses
*/

#include <stdlib.h>
#include <stdio.h>
#include "valid.h"

const MAX_USER_LENGTH = 20;
const MAX_PASS_LENGTH = 20;

int main(int argc, char *argv[]) {

	// Variable Declarations... 
	int ret;
	int Valid_User(char*, char*, char*, char*, char*);
	char *user, *pass, *pdc, *bdc, *domain;
	char user_input[MAX_USER_LENGTH];
	char pass_input[MAX_PASS_LENGTH];


	// Command line arguments 
	if(argc != 1 && argc < 5) {
		// Prompt for username and password 
		user = user_input;
		pass = pass_input;
	
		printf("User: ");
		fgets(user_input, sizeof(user_input), stdin);
		user_input[strlen(user_input)-1] = '\0';

		system("stty -echo");
		printf("Password: ");
		fgets(pass_input, sizeof(pass_input), stdin);
		system("stty echo");
		pass_input[strlen(pass_input)-1] = '\0';
		printf("\n");

		domain = argv[1];
		pdc = argv[2];
		if(argc == 4) {
			bdc = argv[3];
		}
	} else if(argc > 4 && argc < 7 ) {
		// Pull username and password from environment variables 
		user = getenv(argv[1]);
		if(user == NULL) {
			printf("Environment variable '%s' not found by getenv()\n", argv[1]);
			return -1;
		}
		pass = getenv(argv[2]);
		if(pass == NULL) {
			printf("Environment variable '%s' not found by getenv()\n", argv[2]);
			return -1;
		}
		domain = argv[3];
		pdc = argv[4];
		if(argc = 6) {
			bdc = argv[5];
		}
	} else {
		// Print Usage 
		puts("\nsmbauth\nBrian M. Shire <shire@tekrat.com>\n");
		puts("Usage: smbauth (<ENV-User> <ENV-Pass>) <Domain> <PDC> [<BDC>]\n");
		puts("	ENV-User	The Environment variable name to pull for the username");
		puts("	ENV-Pass	The Environment variable name to pull for the password");
		puts("	Domain		Domain Name to validate with");
		puts("	PDC		The Primary Domain Controller IP or NetBIOS name");
		puts("	BDC		The Backup Domain Controller IP or NetBIOS name\n");
		return -1;
	}

	/* Call SMB Authentication method */
	ret = Valid_User(user, pass, pdc, bdc, domain); 
	puts(err2string(ret));	
	return ret;
}
