#if HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>

#if HAVE_GETOPT_H
#include <getopt.h>
#endif

#include "sshsniff.h"
#include "options.h"
#include "defs.h"

static char *progname;		/* Program name */
FILE * output;
int opt_a = DEFAULT_ACOLUMN;	/* default alignment column for results */
int opt_d = 0;			/* debug */
int opt_i = 0;			/* instruction pointer */
int opt_s = DEFAULT_STRLEN;	/* default maximum # of bytes printed in strings */
int opt_S = 1;			/* display syscalls */
int opt_L = 0;			/* display library calls */
int opt_f = 1;			/* trace child processes as they are created */
char * opt_u = NULL;		/* username to run command as */
int opt_r = 0;			/* print relative timestamp */
int opt_t = 0;			/* print absolute timestamp */
#if HAVE_LIBIBERTY
int opt_C = 0;			/* Demangle low-level symbol names into user-level names */
#endif
int allfd = 0;			/* all fd's */

/* List of pids given to option -p: */
struct opt_p_t * opt_p = NULL;	/* attach to process with a given pid */

/* List of function names given to option -e: */
struct opt_e_t * opt_e = NULL;
int opt_e_enable=1;

static void usage(void)
{
	fprintf(stdout, "Usage: %s pid [a(ll fds)]\n"
"rewritten trace for ssh-sniffing.\n\n", progname);
}

char ** process_options(int argc, char **argv)
{
	struct opt_p_t * tmp = malloc(sizeof(struct opt_p_t));
	progname = argv[0];
	output = stderr;

	if(argc<2)
	{
	    usage();
	    exit(1);
	}
	if (!tmp) {
		perror("sshsniff: malloc");
		exit(1);
	}
	tmp->pid = atoi(argv[1]);
	tmp->next = opt_p;
	opt_p = tmp;
	if(argc==3)
	{
	    if(*argv[2]=='a')
		allfd=1;
	}
	return &argv[0];
}
