/***************************************************************************/
/*                                                                         */
/*  elffile.h -  Information passing structure declarations and function   */
/*               prototypes for ELF file handling routines in injectso     */
/*                                                                         */
/*  Copyright (C) 2000 Shaun Clowes                                        */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of version 2 of the GNU General Public License as   */
/*  published by the Free Software Foundation;                             */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/***************************************************************************/

#ifndef _ELFFILE_H
#define _ELFFILE_H

#include <elf.h>

typedef struct _SFileInfo {
   Elf32_Phdr tDynamicSegment;
   Elf32_Phdr tInterpSegment;
   Elf32_Dyn  tPltGotDynamic;
   char *sInterp;
} SFileInfo;
typedef SFileInfo *PSFileInfo;

typedef struct _SHashHeader {
   Elf32_Word tBuckets;
   Elf32_Word tChains;
} SHashHeader;
typedef SHashHeader *PSHashHeader;

int read_target_info(char *sFileName, PSFileInfo ptFileInfo);
int check_library_info(char *sFileName);
char *dynamic_type(Elf32_Sword d_tag);
unsigned long calc_elf_hash(const unsigned char *sName);

#endif
