/***************************************************************************/
/*                                                                         */
/*  errorlog.c - Error logging routines for injectso                       */
/*                                                                         */
/*  Copyright (C) 2000 Shaun Clowes                                        */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of version 2 of the GNU General Public License as   */
/*  published by the Free Software Foundation;                             */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/***************************************************************************/

#include <stdio.h>
#include <errno.h>
#include <stdarg.h>
#include <injectso.h>
#include <errorlog.h>
#include <procdbg.h>
#include <readargs.h>

/* Private variables                                                       */
static int iAborting = 0;

/* Private function prototypes                                             */
void show_error_long(int iAbort, char *sFmt, va_list tAp);

void show_error(char *sFmt, ...) {
   va_list tAp;

   va_start(tAp, sFmt);

   show_error_long(0, sFmt, tAp);
}

void show_abort(char *sFmt, ...) {
   va_list tAp;

   va_start(tAp, sFmt);

   show_error_long(1, sFmt, tAp);
}

void show_error_long(int iAbort, char *sFmt, va_list tAp) {
   int iSaveErr;

   /* Output the program name                                              */
   fputs(sProgName, stderr);
   fputs(": ", stderr);
   if (iAbort)
      fputs("(critical error) ", stderr);
   else
      fputs("(error) ", stderr);

   /* Now output the stuff given to us                                     */
   
   /* Save errno, we don't modify it                                       */
   iSaveErr = errno;

   vfprintf(stderr, sFmt, tAp);

   errno = iSaveErr;

   /* If the abort flag is specified, exit                                 */
   if (iAbort) {
      if (iAborting == 0)
         iAborting = 1;
      else
         return;
      ptrace_detach();
      exit(iAbort);
   }

}

void show_notice(char *sFmt, ...) {
   va_list tAp;    
   int iSaveErr;

   /* Save errno, we don't modify it                                       */
   iSaveErr = errno;

   /* Output the program name                                              */
   fputs(sProgName, stdout);
   fputs(": ", stdout);

   /* Output the message                                                   */
   va_start(tAp, sFmt);
   vfprintf(stdout, sFmt, tAp);

   errno = iSaveErr;
}
   
void show_debug(int iLevel, char *sFmt, ...) {
   va_list tAp;    
   int iSaveErr;

   /* Check the level                                                      */
   if (tProgArgs.iOptDebug < iLevel) 
      return;

   /* Save errno, we don't modify it                                       */
   iSaveErr = errno;

   /* Output the program name                                              */
   fputs(sProgName, stderr);
   fprintf(stderr, ": (debug %d) ", iLevel);

   /* Output the message                                                   */
   va_start(tAp, sFmt);
   vfprintf(stderr, sFmt, tAp);

   errno = iSaveErr;
}
   


