/***************************************************************************/
/*                                                                         */
/*  readargs.h - Function prototypes for exported command line argument    */
/*               processing functions and structure declaration for        */
/*               exported argument data structure.                         */
/*                                                                         */
/*  Copyright (C) 2000 Shaun Clowes                                        */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of version 2 of the GNU General Public License as   */
/*  published by the Free Software Foundation;                             */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/***************************************************************************/

#ifndef _READARGS_H
#define _READARGS_H

#include <sys/types.h>

/* Argument global                                                         */
typedef struct _SProgArgs {
   pid_t tOptPid;             /* PID of process to inject into             */
   int iOptDebug;             /* Debugging level (0 - 3)                   */
   int iOptNoSysRestart;      /* Do NOT attempt to restart syscalls,       */
                              /* return EINTR instead                      */
   int iOptNoHash;            /* Do NOT attempt to use symbol hash tables  */
                              /* to locate symbols in target               */
   char *sOptLibrary;         /* Name of library to inject                 */
   char *sOptTarget;          /* Name of executable file of target process */
   char *sOptCallFunc;        /* Function to call with pointer to dynamic  */
                              /* section of executable after injection     */
} SProgArgs;
extern SProgArgs tProgArgs;

/* Exported functions                                                      */
extern int read_args(int argc, char *argv[]);
extern void usage();

#endif
