/****************************************************************************/
/** samp1.cpp                                                              **/
/** ---------------------------------------------------------------------- **/
/** Example of usage of the syringe.dll to inject samp1_inj.dll to all     **/
/** currently running processes                                            **/
/** ---------------------------------------------------------------------- **/
/** Copyright (C) 1996-98 by OK Thinking Software, All Rights Reserved     **/
/** ---------------------------------------------------------------------- **/
/** August 20, 1998 by Oleg Kagan                                          **/
/****************************************************************************/

//============================================================================
#include <windows.h>
#include <iostream.h>
#include <stdio.h>
#pragma hdrstop

//============================================================================
#include "../syringe/syringe.h"
#include "psapi.h"

// if c_szTargetProcessSubstring == "" or NULL then inject into all processes
//============================================================================
const char* const c_szTargetProcessSubstring = "notepad";
//const char* const c_szTargetProcessSubstring = "samp1";

//============================================================================
size_t GetFullDllName(

	const char* c_szDllName,
	char* szDllFullName,
	size_t nDllFullNameSize

){
	HINSTANCE hLib = LoadLibrary(c_szDllName);
	if (!hLib) return 0;
	size_t nResult = GetModuleFileName(hLib, szDllFullName, nDllFullNameSize);
	FreeLibrary(hLib);
	return nResult;
} /*GetFullDllName(const char*, char*, size_t)*/

//============================================================================
int main(

	int argc,
	char* argv[]

){
	if (!IsWinNt()) {
		MessageBox(
			NULL, 
			"Sorry, but this example works under Microsoft Windows NT only", 
			"samp1.exe", MB_OK | MB_ICONHAND | MB_SYSTEMMODAL
		) /*MessageBox*/;
		return EXIT_FAILURE;
	} /*if*/

	char szDllToInject[MAX_PATH + 1]; *szDllToInject = char(0);
	GetFullDllName("samp1_inj.dll", szDllToInject, sizeof(szDllToInject) - 1);
	szDllToInject[sizeof(szDllToInject) - 1] = char(0);

	if (!*szDllToInject) return EXIT_FAILURE;

	const size_t c_nMaxProc = 4096;
	DWORD a_dwProcIds[c_nMaxProc + 1];

	bool bProcessFound = false;

	DWORD uResult = 0;

	DWORD nEnumProc = 0;
	if (
		EnumProcesses(
			a_dwProcIds, c_nMaxProc * sizeof(DWORD), &nEnumProc
		) /*EnumProcesses*/
	){
		nEnumProc /= sizeof(DWORD);

		for (size_t i = 0; i < nEnumProc; ++i) {
			HANDLE hProcess = OpenProcess(
				PROCESS_ALL_ACCESS, FALSE, a_dwProcIds[i]
			) /*OpenProcess*/;

			char szFileName[MAX_PATH + 1];
			if (
				GetModuleFileNameEx(
					hProcess, NULL, szFileName, sizeof(szFileName) - 1
				) /*GetModuleFileNameEx*/ 
			){
				for (char* p_c = szFileName; *p_c; ++p_c) 
					*p_c = tolower(*p_c);

				if (
					!c_szTargetProcessSubstring || 
					!*c_szTargetProcessSubstring || 
					strstr(szFileName, c_szTargetProcessSubstring)
				){
					bProcessFound = true;
					if (
						!InjectModule(
							hProcess, NULL, szDllToInject, "HackMessageBox", 
							szFileName, sizeof(szFileName), 
							(void**)&uResult, INFINITE
						) /*!InjectModule*/
					) uResult = 0;

					if (!uResult) {
						char szError[MAX_PATH];
						sprintf(szError, "Error: %lu", SyringeGetLastError());
						MessageBox(
							NULL, szError, szFileName, MB_OK | MB_SYSTEMMODAL
						) /*MessageBox*/;
					} /*if*/

					MessageBox(
						NULL, szFileName, 
						uResult ? "Samp1.exe succeed" : "Samp1.exe failed", 
						MB_OK | MB_SYSTEMMODAL | 
							(uResult ? MB_ICONEXCLAMATION : MB_ICONSTOP)
					) /*MessageBox*/;
				} /*if*/
			} /*if*/
		} /*for (size_t i)*/
	} /*if*/

	if (!bProcessFound) {
		MessageBox(
			NULL, "No appropriate process found", "samp1.exe", 
			MB_OK | MB_SYSTEMMODAL | MB_ICONSTOP
		) /*MessageBox*/;
	} /*if*/

	return EXIT_SUCCESS;
} /*main(int, char[])*/
