/****************************************************************************/
/** samp1_inj.cpp                                                          **/
/** ---------------------------------------------------------------------- **/
/** Example of usage of the syringe.dll. Intercepts MessageBoxA and        **/
/** MessageBoxW API calls in the "infected" process                        **/
/** ---------------------------------------------------------------------- **/
/** Copyright (C) 1996-98 by OK Thinking Software, All Rights Reserved     **/
/** ---------------------------------------------------------------------- **/
/** August 20, 1998 by Oleg Kagan                                          **/
/****************************************************************************/

//============================================================================
#include <windows.h>
#pragma hdrstop

//============================================================================
#include <psapi.h>
#include "..\syringe\syringe.h"

// Switch all optimizations off 
// (Visual C specific... For any other compiler do the same thing)
//============================================================================
#ifdef _MSC_VER
	#pragma optimize("", off)
#endif /*defined(_MSC_VER)*/

//============================================================================
void HackTextA(

	char* szText
	
){
	size_t nLength = strlen(szText);
	for (size_t i = 0; i < nLength; ++i) {
		szText[i] = char((i % 2) ? tolower(szText[i]) : toupper(szText[i]));
	} /*for (size_t i)*/
} /*HackTextA(char*)*/

//============================================================================
void HackTextW(

	wchar_t* wszText
	
){
	size_t nLength = wcslen(wszText);
	for (size_t i = 0; i < nLength; ++i) {
		wszText[i] = char(
			(i % 2) ? towlower(wszText[i]) : towupper(wszText[i])
		) /*wszText[i]*/;
	} /*for (size_t i)*/
} /*HackTextW(char*)*/

//============================================================================
typedef int (*TMessageBoxFuncPtrA)(HWND, LPCTSTR, LPCTSTR, UINT);
TMessageBoxFuncPtrA p_fnMessageBoxOrgA = NULL;

//----------------------------------------------------------------------------
typedef int (*TMessageBoxFuncPtrW)(HWND, LPCWSTR, LPCWSTR, UINT);
TMessageBoxFuncPtrW p_fnMessageBoxOrgW = NULL;

//============================================================================
int WINAPI HackedMessageBoxA(

	HWND hWnd,
	LPCTSTR lpText,
	LPCTSTR lpCaption,
	UINT uType

){
	if (!p_fnMessageBoxOrgA) return 0;

	char szNewText[1024];
	char szNewCaption[1024];

	strncpy(szNewText, lpText, sizeof(szNewText) - 1); 
	szNewText[sizeof(szNewText) - 1] = char(0);
	HackTextA(szNewText);

	strncpy(szNewCaption, lpCaption, sizeof(szNewCaption) - 1); 
	szNewCaption[sizeof(szNewCaption) - 1] = char(0);
	HackTextA(szNewCaption);

	int nResult = (*p_fnMessageBoxOrgA)(
		hWnd, szNewText, szNewCaption, uType
	) /*(*p_fnMessageBoxOrgA)*/;
	return nResult;
} /*HackedMessageBoxA(HWND, LPCTSTR, LPCTSTR, UINT)*/

//============================================================================
int WINAPI HackedMessageBoxW(

	HWND hWnd,
	LPCWSTR lpText,
	LPCWSTR lpCaption,
	UINT uType

){
	if (!p_fnMessageBoxOrgW) return 0;

	wchar_t wszNewText[1024];
	wchar_t wszNewCaption[1024];

	wcsncpy(wszNewText, lpText, sizeof(wszNewText) / sizeof(wchar_t) - 1); 
	wszNewText[sizeof(wszNewText) - 1] = wchar_t(0);
	HackTextW(wszNewText);

	wcsncpy(
		wszNewCaption, lpCaption, sizeof(wszNewCaption) / sizeof(wchar_t) - 1
	) /*wcsncpy*/; 
	wszNewCaption[sizeof(wszNewCaption) - 1] = wchar_t(0);
	HackTextW(wszNewCaption);

	int nResult = (*p_fnMessageBoxOrgW)(
		hWnd, wszNewText, wszNewCaption, uType
	) /*(*p_fnMessageBoxOrgW)*/;
	return nResult;
} /*HackedMessageBoxW(HWND, LPCTSTR, LPCTSTR, UINT)*/

//============================================================================
bool HackMessageBoxInModule(

	TInjectInfo& r_InjectInfo, 
	HMODULE hModule,
	bool bNotify

){
	bool bSuccess = false;
	bSuccess |= (bool)r_InjectInfo.p_fnInterceptDllCall(
		hModule, "user32.dll", "MessageBoxA", 
		(PVOID)&HackedMessageBoxA, (PVOID*)&p_fnMessageBoxOrgA, NULL
	) /*r_InjectInfo.p_fnInterceptDllCall*/;

	bSuccess |= (bool)r_InjectInfo.p_fnInterceptDllCall(
		hModule, "user32.dll", "MessageBoxW", 
		(PVOID)&HackedMessageBoxW, (PVOID*)&p_fnMessageBoxOrgW, NULL
	) /*r_InjectInfo.p_fnInterceptDllCall*/;

	if (bNotify) {
		char szModule[MAX_PATH + 1];
		GetModuleFileName(hModule, szModule, sizeof(szModule) - 1);
		MessageBox(
			NULL, szModule, 
			bSuccess ? 
				"MessageBox API hack succeeded" : 
				"MessageBox API hack failed", 
			MB_OK | MB_SYSTEMMODAL |
				(bSuccess ? MB_ICONEXCLAMATION : MB_ICONSTOP)
		) /*MessageBox*/;
	} /*if*/

	return bSuccess;
} /*HackMessageBoxInModule(TInjectInfo&, HMODULE&)*/

//============================================================================
extern "C" PVOID _SYRINGE_EXPORT_ WINAPI HackMessageBox(

	TInjectInfo* pInjectInfo
	
){
	if (!pInjectInfo) return FALSE;

	// Reload itself and injector to avoid unloading after return from 
	// the function
	//-----------------------------------------------------------------
	LoadLibrary(pInjectInfo->szModuleToInject);
	LoadLibrary(pInjectInfo->szSyringeFullName);

	if ((pInjectInfo->pParameter) && (pInjectInfo->nParameterSize)) {
		GetModuleFileName(
			pInjectInfo->hTargetModule, 
			(char*)pInjectInfo->pParameter, pInjectInfo->nParameterSize
		) /*GetModuleFileName*/;
		((char*)pInjectInfo->pParameter)[
			pInjectInfo->nParameterSize - 1
		] /*pInjectInfo->pParameter*/ = char(0);
	} /*if*/

	bool bSuccess = false;

	HMODULE a_hModules[4096]; memset(a_hModules, 0, sizeof(a_hModules));
	DWORD nSubmodules = 0;
	if (
		EnumProcessModules(
			GetCurrentProcess(), a_hModules, sizeof(a_hModules) - 1, 
			&nSubmodules
		) /*EnumProcessModules*/
	){
		nSubmodules /= sizeof(HMODULE);
		for (size_t i = 0; i < nSubmodules; ++i) {
			if (	
				(a_hModules[i] != pInjectInfo->hTargetModule) &&
				(a_hModules[i] != pInjectInfo->hSyringe) &&
				(a_hModules[i] != pInjectInfo->hModuleToInject)
			){
				bSuccess |= (bool)HackMessageBoxInModule(
					*pInjectInfo, a_hModules[i], false
				) /*HackMessageBoxInModule*/;
			} /*if*/
		} /*for (size_t i)*/
	} /*if*/

	bSuccess |= (bool)HackMessageBoxInModule(
		*pInjectInfo, pInjectInfo->hTargetModule, /*true*/ false
	) /*HackMessageBoxInModule*/;

	return (void*)bSuccess;
} /*HackMessageBox(TInjectInfo*)*/

// DllEntryPoint
//============================================================================
extern "C" BOOL WINAPI DllEntryPoint(

	HINSTANCE hDllInstance,  // handle to DLL module 
	DWORD dwReason,  // reason for calling function 
	LPVOID pReserved  // reserved 
 
){
	try {
		switch (dwReason) {
			case DLL_PROCESS_ATTACH: {
#ifdef NEVER
				char szModule[MAX_PATH + 1];
				GetModuleFileName(NULL, szModule, sizeof(szModule) - 1);
				MessageBox(
					NULL, szModule, "Attach samp1_inj.dll", 
					MB_OK | MB_SYSTEMMODAL
				) /*MessageBox*/;
#endif /*NEVER*/
			} /*case DLL_PROCESS_ATTACH*/ break;

			case DLL_PROCESS_DETACH: {
#ifdef NEVER
				char szModule[MAX_PATH + 1];
				GetModuleFileName(NULL, szModule, sizeof(szModule) - 1);
				MessageBox(
					NULL, szModule, "Detach samp1_inj.dll", 
					MB_OK | MB_SYSTEMMODAL
				) /*MessageBox*/;
#endif /*NEVER*/
			} /*case DLL_PROCESS_DETACH*/ break;

			case DLL_THREAD_ATTACH: {
			} /*case DLL_THREAD_ATTACH*/ break;

			case DLL_THREAD_DETACH: {
			} /*case DLL_THREAD_DETACH*/ break;
		} /*switch (dwReason)*/
	} /*try*/
	catch (...) {
		return false;
	} /*catch (...)*/

	return true;
} /*DllEntryPoint(HINSTANCE, DWORD, LPVOID)*/

//============================================================================
void main() {}
