#ifndef __SYRINGE_H__
#define __SYRINGE_H__
/****************************************************************************/
/** syringe.h                                                              **/
/** ---------------------------------------------------------------------- **/
/** Injects custom dll into specified process                              **/
/** ---------------------------------------------------------------------- **/
/** Copyright (C) 1996-98 by OK Thinking Software, All Rights Reserved     **/
/** ---------------------------------------------------------------------- **/
/** August 20, 1998 by Oleg Kagan                                          **/
/****************************************************************************/

//============================================================================
#include <windows.h>

//============================================================================
#ifdef _MSC_VER
	#define _SYRINGE_EXPORT_ __declspec(dllexport)
	#define _SYRINGE_IMPORT_ __declspec(dllimport)
#else 
	#define _SYRINGE_EXPORT_ _export
	#define _SYRINGE_IMPORT_ _import
#endif /*defined(_MSC_VER)*/

//============================================================================
#ifndef _SYRINGE_DECLSPEC_
	#define _SYRINGE_DECLSPEC_ _SYRINGE_IMPORT_
#endif /*!defined(_SYRINGE_DECLSPEC_)*/

//============================================================================
#ifdef __cplusplus
extern "C" {
#endif /*!defined(__cplusplus)*/

//============================================================================
typedef DWORD (WINAPI *TSyringeGetLastErrorPtr)();
//----------------------------------------------------------------------------
typedef DWORD (WINAPI *TSyringeResetLastErrorPtr)();
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TIsWinNtPtr)();
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TInterceptDllCallPtr)(
	HMODULE, const char*, const char*, void*, void**, void*
) /*TInterceptDllCallPtr*/;
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TInjectModulePtr)(
	HANDLE, HANDLE, const char*, const char*, void*, size_t, void**, DWORD 
) /*TInjectModulePtr*/;

// TInjectInfo prototype
//============================================================================
struct TInjectInfo;

// Main function of the injected module
//============================================================================
typedef void* (WINAPI *TInjectDllEntryPointPtr)(struct TInjectInfo*);

// TInjectInfo
//============================================================================
struct TInjectInfo {
	//------------------------------------------------------------------------
	char szSyringeFullName[MAX_PATH + 1];
	HINSTANCE hSyringe;

	//------------------------------------------------------------------------
	char szModuleToInject[MAX_PATH + 1];
	char szEntryPoint[MAX_PATH + 1];

	//------------------------------------------------------------------------
	HINSTANCE hModuleToInject;  // Instance of the injected module
	TInjectDllEntryPointPtr p_fnEntryPoint;  // Entry point
	void* pParameter;  
	size_t nParameterSize;
	void* pResult;  // Result returned from the entry point

	//------------------------------------------------------------------------
	HMODULE hTargetModule;  

	// Services
	//------------------------------------------------------------------------
	TSyringeGetLastErrorPtr p_fnSyringeGetLastError;
	TSyringeResetLastErrorPtr p_fnSyringeResetLastError;
	TIsWinNtPtr p_fnIsWinNt;
	TInterceptDllCallPtr p_fnInterceptDllCall;
	TInjectModulePtr p_fnInjectModule;
} /*TInjectInfo*/;

// Main function of the injected module
//============================================================================
typedef TInjectDllEntryPointPtr TSpringeDllEntryPointPtr;

// Returns last Win32 Error code received by syringe.dll
//============================================================================
DWORD _SYRINGE_DECLSPEC_ WINAPI SyringeGetLastError();
//----------------------------------------------------------------------------
DWORD _SYRINGE_DECLSPEC_ WINAPI SyringeResetLastError();

//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI IsWinNt();

//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI InterceptDllCall(
	HMODULE hLocalModule, 
	const char* c_szDllName, const char* c_szApiName,
	void* pApiNew, void** p_pApiOrg, void* pApiToChange
) /*InterceptDllCall(HMODULE, const char*, const char*, void*,void**,void*)*/;

// Injects specified (c_szModuleToInject) module into specified (hProcess) 
// process and  calls the specified (c_wszEntryPoint) function of injected 
// module in the context of the specified process.
// The "entry point" function have to be of the type TSpringeDllEntryPointPtr
// *p_pResult receives value returned from the entry point (can be NULL).
// dwTimeOutMSec Specifies the time-out interval, in milliseconds. 
// The function returns if the interval elapses, even if the injection didn't 
// complete. If dwTimeOutMSec is zero or INFINITE, the function's time-out 
// interval never elapses. 
// Note: hInstrumentalThread can be handle of any valid thread of the process 
// hProcess (for example PROCESS_INFORMATION.hThread after CreateProcess 
// with CREATE_SUSPENDED flag) and ignored under Windows NT
//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI InjectModule(
	HANDLE hProcess, 
	HANDLE hInstrumentalThread,  // ignored under Windows NT
	const char* c_szModuleToInject, const char* c_szEntryPoint,
	void* pParameter, size_t nParameterSize,
	void** p_pResult,
	DWORD dwTimeOutMSec
) /*InjectModule(HANDLE, HANDLE, const char*, const char*, void*, ...)*/;

//============================================================================
#ifdef __cplusplus
} /*extern "C"*/
#endif /*!defined(__cplusplus)*/

#endif /*!defined(__SYRINGE_H__)*/
