/****************************************************************************/
/** samp1.cpp                                                              **/
/** ---------------------------------------------------------------------- **/
/** Example of usage of the syringe.dll                                    **/
/** ---------------------------------------------------------------------- **/
/** Copyright (C) 1998-99, OK Thinking Software                            **/
/** ---------------------------------------------------------------------- **/
/** This library is free software; you can redistribute it and/or          **/
/** modify it under the terms of the GNU Lesser General Public             **/
/** License as published by the Free Software Foundation; either           **/
/** version 2 of the License, or (at your option) any later version.       **/
/**                                                                        **/
/** This library is distributed in the hope that it will be useful,        **/
/** but WITHOUT ANY WARRANTY; without even the implied warranty of         **/
/** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      **/
/** Lesser General Public License for more details.                        **/
/**                                                                        **/
/** You should have received a copy of the GNU Lesser General Public       **/
/** License along with this library; if not, write to the Free Software    **/
/** Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA **/
/** ---------------------------------------------------------------------- **/
/**                                  Oleg Kagan (oleg_kagan@geocities.com) **/
/** ---------------------------------------------------------------------- **/
/** History:                                                               **/
/** August 13, 1999 - Version 1.0.7                                        **/
/****************************************************************************/

//============================================================================
#include <windows.h>
#include <stdio.h>
#pragma hdrstop

//============================================================================
#include "..\syringe\syringe.h"

//============================================================================
size_t GetFullDllName(

	const char* c_szDllName,
	char* szDllFullName,
	size_t nDllFullNameSize

){
	HINSTANCE hLib = LoadLibrary(c_szDllName);
	if (!hLib) return 0;
	size_t nResult = GetModuleFileName(hLib, szDllFullName, nDllFullNameSize);
	FreeLibrary(hLib);
	return nResult;
} /*GetFullDllName(const char*, char*, size_t)*/

//============================================================================
int main(

	int argc,
	char* argv[]

){
	char szDllToInject[MAX_PATH + 1]; *szDllToInject = char(0);
	GetFullDllName("samp1_inj.dll", szDllToInject, sizeof(szDllToInject) - 1);
	szDllToInject[sizeof(szDllToInject) - 1] = char(0);
	if (!*szDllToInject) return EXIT_FAILURE;

	DWORD uResult = 0;
	char szFullPath[MAX_PATH + 1]; memset(szFullPath, 0, sizeof(szFullPath));
	strcpy(szFullPath, "notepad.exe");

	STARTUPINFO StartupInfo; memset(&StartupInfo, 0, sizeof(StartupInfo));
    StartupInfo.cb = sizeof(StartupInfo);

	PROCESS_INFORMATION ProcessInformation;
	if (
		CreateProcess(
			NULL,
			szFullPath,
			NULL, NULL,
			TRUE,
			CREATE_SUSPENDED | NORMAL_PRIORITY_CLASS,
			NULL,
			NULL,
			&StartupInfo,			
			&ProcessInformation
		) /*CreateProcess*/
	){
		Sleep(100);
		if (
			!InjectModuleA(
				ProcessInformation.hProcess, ProcessInformation.hThread, 
				szDllToInject, "HackMessageBox", 
				NULL, 0, (void**)&uResult, INFINITE
			) /*!InjectModuleA*/
		){
			if (SyringeGetLastError()) {
				sprintf(szFullPath, "Error: %lu", SyringeGetLastError());
			} /*if*/
			MessageBox(
				NULL, szFullPath, 
				uResult ? "samp1.exe succeed" : "samp1.exe failed", 
				MB_OK | MB_SYSTEMMODAL | 
				(uResult ? MB_ICONEXCLAMATION : MB_ICONSTOP)
			) /*MessageBox*/;
		} /*if*/

		ResumeThread(ProcessInformation.hThread);
	} /*if*/

	return EXIT_SUCCESS;
} /*main(int, char[])*/
