#ifndef __SYRINGE_H__
#define __SYRINGE_H__
/****************************************************************************/
/** syringe.h                                                              **/
/** ---------------------------------------------------------------------- **/
/** Injects custom dll into specified process                              **/
/** ---------------------------------------------------------------------- **/
/** Copyright (C) 1998-99, OK Thinking Software                            **/
/** ---------------------------------------------------------------------- **/
/** This library is free software; you can redistribute it and/or          **/
/** modify it under the terms of the GNU Lesser General Public             **/
/** License as published by the Free Software Foundation; either           **/
/** version 2 of the License, or (at your option) any later version.       **/
/**                                                                        **/
/** This library is distributed in the hope that it will be useful,        **/
/** but WITHOUT ANY WARRANTY; without even the implied warranty of         **/
/** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      **/
/** Lesser General Public License for more details.                        **/
/**                                                                        **/
/** You should have received a copy of the GNU Lesser General Public       **/
/** License along with this library; if not, write to the Free Software    **/
/** Foundation,Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA **/
/** ---------------------------------------------------------------------- **/
/**                                  Oleg Kagan (oleg_kagan@geocities.com) **/
/** ---------------------------------------------------------------------- **/
/** History:                                                               **/
/** August 13, 1999 - Version 1.0.7                                        **/
/****************************************************************************/

//============================================================================
#include <windows.h>

//============================================================================
#ifdef _MSC_VER
	#define _SYRINGE_EXPORT_ __declspec(dllexport)
	#define _SYRINGE_IMPORT_ __declspec(dllimport)
#else 
	#define _SYRINGE_EXPORT_ _export
	#define _SYRINGE_IMPORT_ _import
#endif // defined(_MSC_VER)

//============================================================================
#ifndef _SYRINGE_DECLSPEC_
	#define _SYRINGE_DECLSPEC_ _SYRINGE_IMPORT_
#endif // !defined(_SYRINGE_DECLSPEC_)

//============================================================================
#ifdef __cplusplus
extern "C" {
#endif // !defined(__cplusplus)

//============================================================================
typedef DWORD (WINAPI *TSyringeGetLastErrorPtr)();
//----------------------------------------------------------------------------
typedef DWORD (WINAPI *TSyringeResetLastErrorPtr)();
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TIsWinNtPtr)();
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TInterceptDllCallPtr)(
	HMODULE, const char*, const char*, void*, void**, void*
) /*TInterceptDllCallPtr*/;
//----------------------------------------------------------------------------
typedef BOOL (WINAPI* TInjectModulePtr)(
	HANDLE, HANDLE, const char*, const char*, void*, size_t, void**, DWORD 
) /*TInjectModulePtr*/;
//----------------------------------------------------------------------------
typedef BOOL (WINAPI *TEnumModulesPtr)(HMODULE*, size_t, size_t*);

// TInjectInfo prototype
//============================================================================
struct TInjectInfo;

// Main function of the injected module
//============================================================================
typedef void* (WINAPI *TInjectDllEntryPointPtr)(struct TInjectInfo*);

// TInjectInfo
//============================================================================
struct TInjectInfo {
	//------------------------------------------------------------------------
	char szSyringeFullName[MAX_PATH + 1];
	HINSTANCE hSyringe;

	//------------------------------------------------------------------------
	char szModuleToInject[MAX_PATH + 1];
	char szEntryPoint[MAX_PATH + 1];

	//------------------------------------------------------------------------
	HINSTANCE hModuleToInject;  // Instance of the injected module
	TInjectDllEntryPointPtr p_fnEntryPoint;  // Entry point
	void* pParameter;  
	size_t nParameterSize;
	void* pResult;  // Result returned from the entry point

	//------------------------------------------------------------------------
	HMODULE hTargetModule;  

	// Services
	//------------------------------------------------------------------------
	TSyringeGetLastErrorPtr p_fnSyringeGetLastError;
	TSyringeResetLastErrorPtr p_fnSyringeResetLastError;
	TIsWinNtPtr p_fnIsWinNt;
	TInterceptDllCallPtr p_fnInterceptDllCall;
	TInjectModulePtr p_fnInjectModule;
	TEnumModulesPtr p_fnEnumModules;
} /*TInjectInfo*/;

// Main function of the injected module
//============================================================================
typedef TInjectDllEntryPointPtr TSyringeDllEntryPointPtr;

// Returns last Win32 Error code received by syringe.dll
//============================================================================
DWORD _SYRINGE_DECLSPEC_ WINAPI SyringeGetLastError();
//----------------------------------------------------------------------------
DWORD _SYRINGE_DECLSPEC_ WINAPI SyringeResetLastError();

//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI IsWinNt();

//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI InterceptDllCallA(
	HMODULE hLocalModule, 
	const char* c_szDllName, const char* c_szApiName,
	void* pApiNew, void** p_pApiOrg, void* pApiToChange
) /*InterceptDllCallA(HMODULE, const char*, const char*,void*,void**,void*)*/;

//----------------------------------------------------------------------------
BOOL _SYRINGE_DECLSPEC_ WINAPI InterceptDllCallW(
	HMODULE hLocalModule, 
	const wchar_t* c_wszDllName, const wchar_t* c_wszApiName,
	void* pApiNew, void** p_pApiOrg, void* pApiToChange
) /*InterceptDllCallW(HMODULE, const wchar_t*, const wchar_t*, void*, ...)*/;

//----------------------------------------------------------------------------
#ifdef UNICODE
	#define InterceptDllCall InterceptDllCallW
#else
	#define InterceptDllCall InterceptDllCallA
#endif // defined(UNICODE)

// Injects specified (c_szModuleToInject) module into specified (hProcess) 
// process and  calls the specified (c_wszEntryPoint) function of injected 
// module in the context of the specified process.
// The "entry point" function have to be of the type TSyringeDllEntryPointPtr
// *p_pResult receives value returned from the entry point (can be NULL).
// dwTimeOutMSec Specifies the time-out interval, in milliseconds. 
// The function returns if the interval elapses, even if the injection didn't 
// complete. If dwTimeOutMSec is zero or INFINITE, the function's time-out 
// interval never elapses. 
// Note: hInstrumentalThread can be handle of any valid thread of the process 
// hProcess (for example PROCESS_INFORMATION.hThread after CreateProcess 
// with CREATE_SUSPENDED flag) and ignored under Windows NT
//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI InjectModuleA(
	HANDLE hProcess, 
	HANDLE hInstrumentalThread,  // ignored under Windows NT
	const char* c_szModuleToInject, const char* c_szEntryPoint,
	void* pParameter, size_t nParameterSize,
	void** p_pResult,
	DWORD dwTimeOutMSec
) /*InjectModuleA(HANDLE, HANDLE, const char*, const char*, void*, ...)*/;

//----------------------------------------------------------------------------
BOOL _SYRINGE_DECLSPEC_ WINAPI InjectModuleW(
	HANDLE hProcess, 
	HANDLE hInstrumentalThread,  // ignored under Windows NT
	const wchar_t* c_wszModuleToInject, const wchar_t* c_wszEntryPoint,
	void* pParameter, size_t nParameterSize,
	void** p_pResult,
	DWORD dwTimeOutMSec
) /*InjectModuleW(HANDLE, HANDLE, const wchar_t*, const wchar_t*, ...)*/;

//----------------------------------------------------------------------------
#ifdef UNICODE
	#define InjectModule InjectModuleW
#else
	#define InjectModule InjectModuleA
#endif // defined(UNICODE)

// Retrieves a handle for each module in the current process 
//============================================================================
BOOL _SYRINGE_DECLSPEC_ WINAPI EnumModules(
	HMODULE* a_hModules,     // array to receive the module handles
	size_t nSizeInBytes,     // size of the array in bytes
	size_t* p_nBytesWritten  // receives the number of bytes returned 
) /*EnumModules(HMODULE*, size_t, size_t*)*/;

//============================================================================
#ifdef __cplusplus
} /*extern "C"*/
#endif // !defined(__cplusplus)

#endif // !defined(__SYRINGE_H__)
