/****************************************************************************/
/** intercept.cpp                                                          **/
/** ---------------------------------------------------------------------- **/
/** Example of interception of an API or any DLL function call             **/
/** ---------------------------------------------------------------------- **/
/** The method shown here may be very impressive in conjunction with       **/
/** CreateRemoteThread API                                                 **/
/** ---------------------------------------------------------------------- **/
/** July 23, 1998 by Oleg Kagan                                            **/
/****************************************************************************/

//============================================================================
#include <windows.h>
#pragma hdrstop

// Switch all optimizations off 
// (Visual C specific... For any other compiler do the same thing)
//============================================================================
#pragma optimize("", off)

//============================================================================
#define MakePtr(Type, Base, Offset) ((Type)(DWORD(Base) + (DWORD)(Offset)))

//============================================================================
BOOL InterceptDllCall(

	HMODULE hLocalModule, 
	const char* c_szDllName,
	const char* c_szApiName,
	PVOID pApiNew,
	PVOID* p_pApiOrg,
	PVOID pApiToChange
	
){
    PIMAGE_DOS_HEADER pDOSHeader = (PIMAGE_DOS_HEADER)hLocalModule;
    PIMAGE_NT_HEADERS pNTHeader;
    PIMAGE_IMPORT_DESCRIPTOR pImportDesc;
    DWORD dwProtect;
	BOOL bSuccess = FALSE;
    
    DWORD dwAddressToIntercept; 

	if (pApiToChange) {
		dwAddressToIntercept = (DWORD)pApiToChange;
	}
	else {
		dwAddressToIntercept = (DWORD)GetProcAddress(
			GetModuleHandle((char*)c_szDllName), (char*)c_szApiName
		) /*GetProcAddress*/;
	} /*iff*/;

    if (IsBadReadPtr(hLocalModule, sizeof(PIMAGE_NT_HEADERS)))
        return FALSE;
    
    if (pDOSHeader->e_magic != IMAGE_DOS_SIGNATURE)
        return FALSE;
    
    pNTHeader = MakePtr(PIMAGE_NT_HEADERS, pDOSHeader, pDOSHeader->e_lfanew);
    if (pNTHeader->Signature != IMAGE_NT_SIGNATURE)
        return FALSE;
    
    pImportDesc = MakePtr(
		PIMAGE_IMPORT_DESCRIPTOR, hLocalModule, 
        pNTHeader->OptionalHeader.DataDirectory[
			IMAGE_DIRECTORY_ENTRY_IMPORT
		] /*pNTHeader->OptionalHeader.DataDirectory*/.VirtualAddress
	) /*MakePtr*/;
    
    if (pImportDesc == (PIMAGE_IMPORT_DESCRIPTOR)pNTHeader) return FALSE;
    
	while (pImportDesc->Name) {
		PIMAGE_THUNK_DATA pThunk;
    
		pThunk = MakePtr(
			PIMAGE_THUNK_DATA, hLocalModule, pImportDesc->FirstThunk
		) /*MakePtr*/;
    
		while (pThunk->u1.Function) {
			if (DWORD(pThunk->u1.Function) == dwAddressToIntercept) {	
				if (
					!IsBadWritePtr(
						(LPVOID)(&pThunk->u1.Function), sizeof(DWORD)
					) /*!IsBadWritePtr*/
				){
					if (p_pApiOrg) 
						*p_pApiOrg = PVOID(pThunk->u1.Function);
					(PDWORD)pThunk->u1.Function = (PDWORD)pApiNew;
					bSuccess = TRUE;
				}
				else {
					if (
						VirtualProtect(
							(LPVOID)(&pThunk->u1.Function), sizeof(DWORD),
							PAGE_EXECUTE_READWRITE, &dwProtect
						) /*VirtualProtect*/
					){
						DWORD dwNewProtect;

						if (p_pApiOrg) 
							*p_pApiOrg = PVOID(pThunk->u1.Function);
						pThunk->u1.Function = (PDWORD)pApiNew;
						bSuccess = TRUE;

						dwNewProtect = dwProtect;
						VirtualProtect(
							(LPVOID)(&pThunk->u1.Function), sizeof(DWORD),
							dwNewProtect, &dwProtect
						) /*VirtualProtect*/;
					} /*if*/
				} /*iff*/
			} /*if*/
			pThunk++;
		} /*while*/
		pImportDesc++;
	} /*while*/

    return bSuccess;
} /*InterceptDllCall(HMODULE, const char*, const char*, PVOID,PVOID*,PVOID)*/

//============================================================================
void ChangeText(

	char* szText
	
){
	size_t nLength = strlen(szText);
	for (size_t i = 0; i < nLength; ++i) {
		szText[i] = char((i % 2) ? tolower(szText[i]) : toupper(szText[i]));
	} /*for (size_t i)*/
} /*ChangeText(char*)*/

//============================================================================
typedef int (WINAPI *TMessageBoxFuncPtr)(HWND, LPCTSTR, LPCTSTR, UINT);
TMessageBoxFuncPtr p_fnMessageBoxOrg = NULL;

//============================================================================
int WINAPI MyMessageBox(

	HWND hWnd,          // handle of owner window
	LPCTSTR lpText,     // address of text in message box
	LPCTSTR lpCaption,  // address of title of message box
	UINT uType          // style of message box

){
	if (!p_fnMessageBoxOrg) return 0;
	ChangeText((char*)lpText); ChangeText((char*)lpCaption);
	int nResult = (*p_fnMessageBoxOrg)(hWnd, lpText, lpCaption, uType);
	return nResult;
} /*MyMessageBox(HWND, LPCTSTR, LPCTSTR, UINT)*/

//============================================================================
extern "C" int WINAPI WinMain(

	HINSTANCE hInstance,  // handle to current instance 
	HINSTANCE /*hPrevInstance*/,  // handle to previous instance 
	LPSTR szCmdLine,  // pointer to command line 
	int /*nCmdShow*/  // show state of window 

){
	char* c_szTitle = "API Call Interception";
	UINT uStyle = MB_OK | MB_ICONHAND | MB_SYSTEMMODAL;

	MessageBox(NULL, "Here it is normal                 ", c_szTitle, uStyle);

	// Lets Change it
	//----------------
	InterceptDllCall(
		hInstance, "user32.dll", "MessageBoxA", 
		(PVOID)&MyMessageBox, (PVOID*)&p_fnMessageBoxOrg, 
		NULL
	) /*InterceptDllCall*/;

	MessageBox(NULL, "Beware of the mad hackers         ", c_szTitle, uStyle);

	InterceptDllCall(
		hInstance, "user32.dll", "MessageBoxA", 
		(PVOID)p_fnMessageBoxOrg, NULL, (PVOID)MyMessageBox
	) /*InterceptDllCall*/;

	MessageBox(NULL, "Here it is almoust normal again :)", c_szTitle, uStyle);

	return EXIT_SUCCESS;
} /*WinMain(HINSTANCE, HINSTANCE, LPSTR, int)*/ 
