/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <stdlib.h>
# include <string.h>
# include <errno.h>
# include <unistd.h>
# include <fcntl.h>
# include <sys/types.h>
# include <sys/time.h>
# include <sys/socket.h>
# include <sys/ioctl.h>
# include <sys/select.h>
# include <net/if.h>
# ifdef HAVE_NET_IF_VAR_H
#  include <net/if_var.h>
# endif
# ifdef HAVE_NET_IF_TAP_H
#  include <net/if_tap.h>
# endif
# ifdef HAVE_NET_IF_TUN_H
#  include <net/if_tun.h>
# endif
# ifdef HAVE_LINUX_IF_TUN_H
#  include <linux/if_tun.h>
# endif
# include "epp.h"
# include "../libutil/util.h"

RCSID("$Id: epp_tap.c,v 1.6 2000/11/14 16:09:21 hbb Exp $")

char	*ifname;

void init_tap(void);
void dump_packet(u_char *, u_int);

int
main(int argc, char *argv[])
{
	int opt;

	set_argv0(progname = argv[0]);
	while((opt = getopt(argc, argv, "v")) != EOF)
		switch(opt) {

		  case 'v':
			verb_option("all");
			break;
		}

	argc -= optind;
	argv += optind;

	if(argc != 1)
		panic("need one arg");

	ifname = argv[0];

	init_tap();
	init_sigs();
	open_shmem();

	loop();
}

void
init_tap(void)
{
	if((fd = open(ifname, O_RDWR, 0)) < 0)
		panic("open(%s): %s", ifname, strerror(errno));

	verb(V_DFLT, 1, "open %s on fd=%d\n", ifname, fd);

# ifdef TAPGIFINFO
	{
		struct tapinfo tapinfo;

		if(ioctl(fd, TAPGIFINFO, &tapinfo))
			panic("TAPGIFINFO: %s", strerror(errno));

		verb(V_DFLT, 1, "old.baudrate=%d\n", tapinfo.baudrate);
		verb(V_DFLT, 1, "old.mtu=%d\n", tapinfo.mtu);
		verb(V_DFLT, 1, "old.type=%u\n", tapinfo.type);

		tapinfo.baudrate = 0;
		tapinfo.type = 0;
		tapinfo.mtu = ETHMTU;

		if(ioctl(fd, TAPSIFINFO, &tapinfo))
			panic("TAPSIFINFO: %s", strerror(errno));

		if(ioctl(fd, TAPGIFINFO, &tapinfo))
			panic("TAPGIFINFO: %s", strerror(errno));

		verb(V_DFLT, 1, "new.baudrate=%d\n", tapinfo.baudrate);
		verb(V_DFLT, 1, "new.mtu=%d\n", tapinfo.mtu);
		verb(V_DFLT, 1, "new.type=%u\n", tapinfo.type);
	}
# endif

# ifdef TUNSETIFF
	{
		struct ifreq ifr;

		memset(&ifr, 0, sizeof(ifr));
		ifr.ifr_flags = IFF_TAP | IFF_NO_PI;

		if(ioctl(fd, TUNSETIFF, (void *)&ifr) < 0)
			panic("TUNSETIFF: %s", strerror(errno));
		ifname = xstrsave(ifr.ifr_name);
	}
# endif
}

/*
 * Filter an input frame. We assume, that we only get packets, we should
 * really get. This means, there is no sense to filter.
 */
int
input_filter(u_char *buf UNUSED)
{
	return 1;
}

/*
 * All filtering should be done in the IP layers on both sides,
 * so we do no filtering altogether.
 */
void
set_filter()
{
}

/*
 * Transmit a frame.
 */
void
transmit()
{
	int ret;

	if(xlen < 14) {
		verb(V_DFLT, 1, "frame too short: %d", xlen);
		return;
	}
	if(verb_level(V_DFLT) > 1)
		dump_packet(xbuf, xlen);
	if((ret = write(fd, xbuf, xlen)) < 0)
		panic("write: %s", strerror(errno));
	if((u_int)ret != xlen)
		panic("write: bad %d %u", ret, xlen);
}

u_int
read_input(u_char **pbuf, int *more)
{
	static char	rbuf[2048];
	int len;

	*more = 0;
	if((len = read(fd, rbuf, sizeof(rbuf))) < 0)
		panic("tap: %s", strerror(errno));
	if(len == 0)
		panic("tap: EOF");

	*pbuf = rbuf;
	if(verb_level(V_DFLT) > 1)
		dump_packet(rbuf, len);

	if(len > 0 && len < ETHMIN)
		len = ETHMIN;

	return len;
}

/*
 * Generate local info string.
 */
# define P	buf+strlen(buf)
void
do_info(char *buf)
{
	sprintf(P, "epp_tap ifname=%s fd=%d", ifname, fd);
}

/*
 * Reset of QNA.
 */
void
reset()
{
}

/*
 * Change receiver state.
 */
void
rcv_enable_change()
{
}


void
dump_packet(u_char *p, u_int len)
{
	fprintf(stderr, "%02x:%02x:%02x:%02x:%02x:%02x ",
		p[0], p[1], p[2], p[3], p[4], p[5]);
	p += 6; len -= 6;
	fprintf(stderr, "%02x:%02x:%02x:%02x:%02x:%02x ",
		p[0], p[1], p[2], p[3], p[4], p[5]);
	p += 6; len -= 6;
	fprintf(stderr, "%04x", (p[0] << 8) | p[1]);
	if(((p[0] << 8) | p[1]) != 0x0800) {
		fprintf(stderr, "\n");
		return;
	}
	p += 2; len -= 2;
	if(len < 20) {
		fprintf(stderr, " too short!\n");
		return;
	}
	fprintf(stderr, " v=%x", (p[0] >> 4) & 0xf);
	if((p[0] & 0xf0) != 0x40) {
		fprintf(stderr, "!\n");
		return;
	}
	fprintf(stderr, " hl=%d", p[0] & 0xf);
	fprintf(stderr, "\n");
}
