/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <stdlib.h>
# include <sys/types.h>
# include <sys/stat.h>
# include <errno.h>
# include <fcntl.h>
# include <unistd.h>
# include <string.h>
# include <begemot.h>

# include "cdefs.h"
# include "tty.h"

RCSID("$Id: tty_fifo.c,v 1.7 2000/06/15 11:18:57 hbb Exp $")


int		cs7;
char		*fname;

static char usgtxt[] =
"Begemot PDP11 emulator Version %s; Terminal-to-fifo adapter\n"
"Copyright (c) 1994-2000 Begemot Computer Associates. All rights reserved.\n"
"Usage: tty_fifo [-7] fifo\n"
"where:\n"
"	-7	mask to 7bits\n";

static void usage(int) DEAD_FUNC;

static void
usage(int e)
{
	fprintf(stderr, usgtxt, VERSION);
	exit(e);
}


void
Exit(int ex)
{
	unlink(fname);
	exit(ex);
}

/*
 * fd 0 is socket to parent
 */
int
main(int argc, char *argv[])
{
	int	opt;
	int	fd;

	while((opt = getopt(argc, argv, "h7")) != EOF)
		switch(opt) {

		  case 'h':
			usage(0);

		  case '7':
			cs7 = 1;
			break;
		}
	argc -= optind;
	argv += optind;

	tty_init();

	if(mkfifo(fname = argv[0], 0666)) {
		error("mkfifo(%s): %s", argv[0], strerror(errno));
		exit(80);
	}
	if((fd = open(fname, 2)) < 0) {
		error("open(%s): %s", argv[0], strerror(errno));
		exit(errno);
	}
	if(setsid() < 0) {
		error("setsid(): %s", strerror(errno));
		exit(82);
	}

	tty_loop(fd);

	Exit(0);
}

void
process_output()
{
	if(cs7)
		makecs7();
}

void
process_input()
{
}
void
process_end()
{
}
