/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: proc.h,v 1.16 2000/11/24 10:34:24 hbb Exp $ */

# ifndef bits_h
# define bits_h

/*
 * floating status bit definitions
 */
enum {
	FER	= 0100000,	/* floating error */
	FID	=  040000,	/* interrupt disable */
	FIUV	=   04000,	/* interrupt on undefined variable */
	FIU	=   02000,	/* interrupt on underflow */
	FIV	=   01000,	/* interrupt on overflow */
	FIC	=    0400,	/* interrupt on integer conversion error */
	FD	=    0200,	/* floating double precision mode */
	FL	=    0100,	/* floating long-integer mode */
	FT	=     040,	/* floating chop mode */
	FN	=     010,	/* neg */
	FZ	=      04,	/* zero */
	FV	=      02,	/* overflow */
	FC	=      01,	/* carry */
};

/*
 * floating point errors
 */
enum {
	FE_ILL	= 2,		/* illegal opcode */
	FE_DIV0	= 4,		/* divide by zero */
	FE_INT	= 6,		/* integer conversion error */
	FE_OFL	= 8,		/* overflow */
	FE_UFL	= 10,		/* underflow */
	FE_UND	= 12,		/* undefined variable */
};

/*
 * CPU options/maintenance register bits
 */
enum {
	CPU_PWOK	= 0000001,	/* BPOK (AC power ok) */
	CPU_PWUP_MASK	= 0000006,	/* power up mask */
	 CPU_PWUP_T24	= 0000000,	/* trap to 24 */
	 CPU_PWUP_MON	= 0000002,	/* enter monitor */
	 CPU_PWUP_AUTO	= 0000004,	/* 173000g */
	 CPU_PWUP_USER	= 0000006,	/* user boot address (from high bits) */
	CPU_HALT	= 0000010,	/* trap to 4 on kernel HALT */
	CPU_MOD_MASK	= 0000360,	/* module type */
	 CPU_MOD_KDJ11A	= 0000020,	/* KDJ11A dual board 11/73 */
	 CPU_MOD_KDJ11B	= 0000040,	/* KDJ11B quad board 11/73,83,84 */
	 CPU_MOD_KXJ11C	= 0000060,	/* KDJ11X co-processor */
	 CPU_MOD_KDJ11D	= 0000100,	/* KDJ11D 11/53 */
	 CPU_MOD_KDJ11E	= 0000120,	/* KDJ11E 11/93,94 */
	CPU_FPA		= 0000400,	/* FPA available */
	CPU_UNIBUS	= 0001000,	/* UNIBUS adaptor available */
	CPU_USER	= 0176000,	/* user start address */
};

/*
 * Memory management bits
 */
enum {
	MMR0_ANR	= 0100000,	/* abort non-resident */
	MMR0_APL	= 0040000,	/* abort page length */
	MMR0_ARO	= 0020000,	/* abort read-only */
	MMR0_ABORT_MASK	= 0160000,	/* all abort bits */
	MMR0_MAI	= 0000400,	/* maintenance (not implemented) */
	MMR0_MODE	= 0000140,	/* mode from PSW at during abort */
	MMR0_MODE_SHIFT	= 5,
	MMR0_SPACE	= 0000020,	/* address space during abort */
	MMR0_SPACE_SHIFT= 4,
	MMR0_PAGE	= 0000016,	/* aborted page number */
	MMR0_PAGE_SHIFT	= 1,
	MMR0_ENABLE	= 0000001,	/* memory management enable */

	MMR3_IOM	= 0000040,	/* not implemented */
	MMR3_22B	= 0000020,	/* enable 22 bit mapping */
	MMR3_KSEP	= 0000004,	/* kernel separate I/D enable */
	MMR3_SSEP	= 0000002,	/* supervisor separate I/D enable */
	MMR3_USEP	= 0000001,	/* user separate I/D enable */
	MMR3_MASK	= 0000077,	/* writeable bits */
};

enum {
	MMG_0		= 017777572,
	MMG_1		= 017777574,
	MMG_2		= 017777576,
	MMG_3		= 017772516,
	MMG_UIPDR0	= 017777600,
	MMG_SIPDR0	= 017772200,
	MMG_KIPDR0	= 017772300,
	MEM_ERROR	= 017777744,
	MEM_CACHE	= 017777746,
	MEM_HITMISS	= 017777752,
};

enum {
	PDR_RES		= 0000002,	/* page is resident */
	PDR_RW		= 0000004,	/* writeable */
	PDR_STACK	= 0000010,	/* stack page */
	PDR_DIRTY	= 0000100,	/* page is dirty */
	PDR_LEN		= 0077400,	/* number of blocks */
	PDR_LEN_SHIFT	= 8,
	PDR_MASK	= 0077516,	/* all used bits */
};

# endif
