/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <signal.h>
# include <string.h>
# include <errno.h>

# include <begemot.h>
# include "../cdefs.h"
# include "util.h"

RCSID("$Id: catchsig.c,v 1.4 2000/03/04 08:04:06 hbb Exp $")

void
catch_signal(int sig, void (*act)(int))
{
	struct sigaction	sa, osa;
	sigset_t		set;

	sigemptyset(&set);
	sa.sa_mask = set;
	sa.sa_handler = act;
	sa.sa_flags = SA_RESTART;
	if(sigaction(sig, &sa, &osa))
		panic("unexpected error in sigaction: %s", strerror(errno));
}
