/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */

# include <stdio.h>
# include <stdlib.h>
# include <unistd.h>
# include <fcntl.h>
# include <string.h>
# include <errno.h>
# include <sys/types.h>
# include <sys/mman.h>

# include <begemot.h>
# include "../cdefs.h"
# include "util.h"

RCSID("$Id$")

caddr_t
mmap_shared_child(size_t len, int fd)
{
	caddr_t c;

	if((int)(c = mmap(NULL,len,PROT_READ|PROT_WRITE,MAP_SHARED,fd,0))==-1)
		panic("child mmap: %s", strerror(errno));

	return c;
}
