/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: qna_regs.h,v 1.8 2000/11/14 16:09:20 hbb Exp $ */

typedef struct qna	qna_t;
typedef struct bdesc	bdesc_t;

struct qna {
	u_short	qna_addr[2];
	u_short	qna_rbdl[2];
	u_short	qna_tbdl[2];
	u_short	qna_vec;
	u_short	qna_csr;
};

# define QNA_RI		0100000		/* receive interrupt request */
# define QNA_CA		0020000		/* carrier */
# define QNA_OK		0010000		/* fuse ok */
# define QNA_SE		0002000		/* sanity timer enable */
# define QNA_EL		0001000		/* external loopback */
# define QNA_IL		0000400		/* internal loopback off */
# define QNA_XI		0000200		/* transmit interrupt request */
# define QNA_IE		0000100		/* interrupt enable */
# define QNA_RL		0000040		/* receive list invalid */
# define QNA_XL		0000020		/* transmit list invalid */
# define QNA_BD		0000010		/* boot/diag rom */
# define QNA_NI		0000004		/* non-existent memory */
# define QNA_SR		0000002		/* software reset */
# define QNA_RE		0000001		/* receiver enable */

struct bdesc {
	u_short	bd_flag;
	u_short	bd_desc;
	u_short	bd_addr;
	u_short	bd_len;
	u_short	bd_stat1;
	u_short	bd_stat2;
};

# define BD_VALID	0100000		/* buffer/address valid */
# define BD_CHAIN	0040000		/* chained buffer */
# define BD_EOM		0020000		/* end of message */
# define BD_SETUP	0010000		/* setup packet */
# define BD_LBYTE	0000200		/* low byte only termination */
# define BD_HBYTE	0000100		/* high byte only start */
# define BD_DESC_MSK	0170377		/* mask for bd_desc */

# define BD_USED	0040000		/* used buffer */
# define BD_ERROR	0040000		/* error */
# define BD_LOSS	0010000		/* loss of carrier */
# define BD_NOCAR	0004000		/* no carrier */
# define BD_STE16	0002000		/* 4 minute sanity timer */
# define BD_ABORT	0001000		/* excessive collosions */
# define BD_FAIL	0000400		/* heartbeat failure */
# define BD_COUNT	0000360		/* collision count */
# define BD_ESETUP	0020000		/* looped back setup */
# define BD_DISCARD	0010000		/* */
# define BD_RUNT	0004000		/* runt packet */
# define BD_RBLH	0003400		/* receive packet length 8:10 */
# define BD_FRAME	0000004		/* frame alignment error */
# define BD_CRCERR	0000002		/* crc error */
# define BD_OVF		0000001		/* epp overflow */
# define BD_RBLL	0000377		/* receive packet length 0:7 */
