/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class ConnectDialog
extends SharpDialog {
    private JFrame frame;
    private JOptionPane optionPane;
    private JCheckBox lockTableBox;
    private JCheckBox verifySaveBox;
    private static final ImageIcon removeIcon = SharpTools.getImageIcon("no.gif");
    private static final ImageIcon databaseIcon = SharpTools.getImageIcon("database32.gif");
    private static final ImageIcon dbErrorIcon = null;
    private Connection dbConnection = null;
    private final JTextField connectnameField = new JTextField();
    private final JTextField usernameField = new JTextField();
    private final JPasswordField passwordField = new JPasswordField();
    private final JTextField driverField = new JTextField();
    private final JTextField urlField = new JTextField();
    private final JCheckBox saveConnection = new JCheckBox("Save Connection", true);
    private final JCheckBox savePassword = new JCheckBox("Save Password", false);
    private int maxConn = 0;
    private final JButton removeButton = new JButton("Remove", removeIcon);
    private JComboBox box;

    public ConnectDialog(JFrame jFrame) {
        super(jFrame, "Connect to Database", true);
        Object object;
        this.frame = jFrame;
        final Config config = SharpTools.getConfig();
        this.maxConn = config.getInt("NUMCONNECTIONS");
        Vector<String> vector = new Vector<String>();
        vector.add("Previous connections");
        int n = 1;
        while (n <= this.maxConn) {
            object = config.get("CONNECTION." + n + ".NAME");
            if (object == null || ((String)object).length() <= 0) break;
            vector.add((String)object);
            ++n;
        }
        this.box = new JComboBox(vector);
        this.box.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n = ConnectDialog.this.box.getSelectedIndex();
                    if (n <= 0) {
                        return;
                    }
                    String string = "CONNECTION." + n;
                    ConnectDialog.this.connectnameField.setText(config.get(string + ".NAME"));
                    ConnectDialog.this.usernameField.setText(config.get(string + ".USERNAME"));
                    ConnectDialog.this.passwordField.setText(config.get(string + ".PASSWORD"));
                    ConnectDialog.this.urlField.setText(config.get(string + ".URL"));
                    ConnectDialog.this.driverField.setText(config.get(string + ".DRIVER"));
                }
            }
        });
        this.removeButton.setToolTipText("Remove the selected connection");
        this.removeButton.setMnemonic(82);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConnectDialog.this.box.getSelectedIndex();
                if (n <= 0) {
                    return;
                }
                int n2 = n;
                while (n2 < ConnectDialog.this.maxConn) {
                    config.set("CONNECTION." + n2 + ".NAME", config.get("CONNECTION." + (n2 + 1) + ".NAME"));
                    config.set("CONNECTION." + n2 + ".USERNAME", config.get("CONNECTION." + (n2 + 1) + ".USERNAME"));
                    config.set("CONNECTION." + n2 + ".PASSWORD", config.get("CONNECTION." + (n2 + 1) + ".PASSWORD"));
                    config.set("CONNECTION." + n2 + ".URL", config.get("CONNECTION." + (n2 + 1) + ".URL"));
                    config.set("CONNECTION." + n2 + ".DRIVER", config.get("CONNECTION." + (n2 + 1) + ".DRIVER"));
                    ++n2;
                }
                String string = "CONNECTION." + ConnectDialog.this.maxConn;
                config.set(string + ".NAME", "");
                ConnectDialog.this.box.setSelectedIndex(0);
                ConnectDialog.this.box.removeItemAt(n);
            }
        });
        object = new JPanel(new FlowLayout());
        ((Container)object).add(this.box);
        ((Container)object).add(this.removeButton);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(this.saveConnection);
        jPanel.add(this.savePassword);
        Object[] objectArray = new Object[]{object, "Connection Name:", this.connectnameField, "Username:", this.usernameField, "Password:", this.passwordField, "Driver:", this.driverField, "URL:", this.urlField, jPanel};
        this.setOptionPane(objectArray, -1, 2, databaseIcon);
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    protected boolean onOK() {
        String string = this.connectnameField.getText().trim();
        String string2 = this.usernameField.getText().trim();
        String string3 = String.copyValueOf(this.passwordField.getPassword());
        String string4 = this.driverField.getText().trim();
        String string5 = this.urlField.getText().trim();
        if (!(string2 != null && string2.length() != 0 || string5 != null && string5.length() != 0 || string4 != null && string4.length() != 0)) {
            SharpOptionPane.showMessageDialog(this, "You must provide values for Username, Url and Driver.\n", "Connect", 1, databaseIcon);
            return false;
        }
        try {
            Class.forName(string4);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SharpOptionPane.showMessageDialog(this, "Unable to load class " + string4 + ". Please ensure that it is in your classpath.\n" + classNotFoundException.toString(), "Class Not Found", 0, dbErrorIcon);
            return false;
        }
        try {
            this.dbConnection = DriverManager.getConnection(string5, string2, string3);
        }
        catch (SQLException sQLException) {
            SharpOptionPane.showMessageDialog(this, "Unable to connect to the database at " + string5 + ".\nPlease ensure that the URL, Username and Password are correct.\n\n" + sQLException.toString(), "Connect", 0, dbErrorIcon);
            return false;
        }
        if (!this.saveConnection.isSelected()) {
            return true;
        }
        if (string.length() == 0) {
            SharpOptionPane.showMessageDialog(this, "You did not enter a connection name.\n\nThis connection succeeded but will not be saved.\n", "Save Connection", 2);
            return true;
        }
        int n = 1;
        while (n < this.box.getItemCount()) {
            if (string.equals(this.box.getItemAt(n).toString())) break;
            ++n;
        }
        if (n != this.box.getItemCount() || this.box.getItemCount() <= this.maxConn) {
            String string6 = "CONNECTION." + n;
            Debug.println("Saving " + string6);
            Config config = SharpTools.getConfig();
            config.set(string6 + ".NAME", string);
            config.set(string6 + ".USERNAME", string2);
            if (this.savePassword.isSelected()) {
                config.set(string6 + ".PASSWORD", string3);
            }
            config.set(string6 + ".URL", string5);
            config.set(string6 + ".DRIVER", string4);
        } else {
            SharpOptionPane.showMessageDialog(this, "You have defined " + this.maxConn + " connections.\nYour current connection setting cannot be saved.\n\nRefer to the manual for advanced configuration.\n", "Save Connection", 2);
        }
        return true;
    }

    protected void onOpen() {
        this.connectnameField.requestFocus();
    }
}

