/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

public class HelpOp {
    private final JEditorPane htmlPane;
    private JScrollPane scrollPane;
    private JFrame frame;
    private Container container;
    private WindowListener exitListener;
    private HyperlinkListener linkListener;
    private URL url;
    static final String message = "<html><font size=3 color=black><p><font size=+1 color=blue><b>Sharp Tools Spreadsheet</b></font> Version 1.4</p><p><p>a product of the Sharp Tools Software Engineering Team<p>Copyright (c) 2000-2002<p><p><font color=green><b>Credits:</b><font></p><ul><li>Hua Zhong</li><li>Ricky Chin</li><li>Daniel Goldberg</li><li>Daniel Medina</li><li>Andrei Scudder</li></ul></p><font color=blue><u><p>http://www.cs.columbia.edu/sharptools/</p><p>mailto:sharp@cs.columbia.edu</p></u></font></font>";

    public HelpOp(URL uRL) {
        this.frame = new JFrame("Help Browser: " + uRL);
        this.container = this.frame.getContentPane();
        this.container.setLayout(new BorderLayout());
        try {
            this.htmlPane = new JEditorPane(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.htmlPane.setEditable(false);
        this.linkListener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL uRL = hyperlinkEvent.getURL();
                if (uRL == null) {
                    return;
                }
                Document document = HelpOp.this.htmlPane.getDocument();
                try {
                    HelpOp.this.htmlPane.setPage(uRL);
                }
                catch (IOException iOException) {
                    HelpOp.this.htmlPane.setDocument(document);
                }
            }
        };
        this.htmlPane.addHyperlinkListener(this.linkListener);
        this.scrollPane = new JScrollPane(this.htmlPane);
        this.container.add(this.scrollPane);
        this.scrollPane.setPreferredSize(new Dimension(500, 500));
        this.exitListener = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        };
        this.frame.addWindowListener(this.exitListener);
        this.frame.pack();
        this.frame.show();
    }

    public static void showAboutBox(JFrame jFrame) {
        SharpOptionPane.showMessageDialog(jFrame, message, "About Sharp Tools Spreadsheet", 1, SharpTools.getImageIcon("skull.gif"));
    }

    public static JComponent createFunctionListComponent(JFrame jFrame, JTable jTable) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        String[] stringArray = new String[]{"Functions", "ABS", "AVERAGE", "COUNT", "E", "INT", "LOG", "MAX", "MEANDEV", "MEDIAN", "MIN", "PI", "RANGE", "ROUND", "SQRT", "SUM", "STDDEV", "SIN", "COS", "TAN", "ASIN", "ACOS", "ATAN"};
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        Dimension dimension = jComboBox.getSize();
        jComboBox.setPreferredSize(new Dimension(100, (int)dimension.getHeight()));
        jPanel.add(jComboBox, "West");
        jComboBox.addActionListener(new FunctionListListener(jFrame, jTable));
        return jPanel;
    }
}

