/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class Histogram
extends JFrame
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel model;
    private JTabbedPane tab;
    private int width;
    private int height;
    private String title;
    private Point location;
    private Dimension dim;
    private final ImageIcon histogramIcon = SharpTools.getImageIcon("chart.gif");

    Histogram(SharpTools sharpTools, String string, int n, int n2) {
        super(string);
        this.setSize(n, n2);
        this.sharp = sharpTools;
        this.table = sharpTools.getTable();
        this.model = sharpTools.getTableModel();
        this.title = string;
        this.width = n;
        this.height = n2;
        this.tab = new JTabbedPane();
        this.table.registerKeyboardAction(this, "Show", KeyStroke.getKeyStroke(119, 0, false), 0);
        this.table.registerKeyboardAction(this, "Add", KeyStroke.getKeyStroke(72, 2, false), 0);
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.tab, "Center");
        this.setDefaultCloseOperation(2);
    }

    private void bringToFront() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
    }

    public void show() {
        super.show();
        this.sharp.checkShowHistogramState();
    }

    public void hide() {
        super.hide();
        this.sharp.checkShowHistogramState();
    }

    public void add(String string, CellRange cellRange) {
        this.bringToFront();
        if (!this.isVisible()) {
            this.show();
        }
        TabPanel tabPanel = new TabPanel(this.model, cellRange, this, this.tab);
        this.tab.addTab(string, null, tabPanel, cellRange.toString());
        this.tab.setSelectedIndex(this.tab.getTabCount() - 1);
        tabPanel.getOptions(true);
    }

    public void toggle() {
        if (this.isVisible()) {
            this.hide();
        } else if (this.hasChart()) {
            this.bringToFront();
            this.show();
        }
    }

    public void addHistogram() {
        if (this.table.getSelectedRowCount() != 0) {
            CellRange cellRange = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            String string = "Chart " + (this.tab.getTabCount() + 1);
            this.add(string, cellRange);
            this.sharp.checkShowHistogramState();
        } else {
            this.sharp.noCellsSelected("Histogram");
        }
    }

    public boolean hasChart() {
        return this.tab.getTabCount() > 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("Show") == 0) {
            this.toggle();
        } else if (actionEvent.getActionCommand().compareTo("Add") == 0) {
            this.addHistogram();
        }
    }
}

