/*
 * Decompiled with CFR 0.152.
 */
import java.util.LinkedList;

public class Node {
    public static final int DEFAULT = 0;
    public static final int REL_ADDR = 1;
    public static final int ABS_ADDR = 2;
    public static final int FUNCTION = 3;
    public static final int LPAREN = 4;
    public static final int RPAREN = 5;
    public static final int NUMBER = 6;
    public static final int OPERATOR = 7;
    public static final int COMMA = 8;
    public static final int COLON = 9;
    public static final int EXP = 10;
    private static final String[] desc = new String[]{"Default", "Rel_Addr", "Abs_Addr", "Function", "LBracket", "RBracket", "Number", "Operator", "Comma", "Colon", "Param"};
    private int type;
    private String data;
    private float number;
    private int row;
    private int col;
    private LinkedList exp;
    private Node nextRange;
    private boolean pending;

    Node() {
    }

    Node(Node node) {
        this.type = node.type;
        if (this.data != null) {
            this.data = new String(node.data);
        }
        this.number = node.number;
        this.row = node.row;
        this.col = node.col;
    }

    public int getType() {
        return this.type;
    }

    public boolean isType(int n) {
        return this.type == n;
    }

    public float getNumber() {
        return this.number;
    }

    public String getData() {
        return this.data;
    }

    public LinkedList getParams() {
        return this.exp;
    }

    public Node getNextRange() {
        return this.nextRange;
    }

    public LinkedList getExp() {
        return this.exp;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public void setType(int n) {
        this.type = n;
    }

    public void setNumber(float f) {
        this.number = f;
    }

    public void setData(String string) {
        this.data = string;
    }

    public void appendData(char c) {
        this.data = this.data + c;
    }

    public void appendData(String string) {
        this.data = this.data + string;
    }

    public void setParams(LinkedList linkedList) {
        this.exp = linkedList;
    }

    public void addParam(Node node) {
        if (node.getExp().size() > 0) {
            this.exp.add(node);
        }
    }

    public void setNextRange(Node node) {
        this.nextRange = node;
    }

    public void setExp(LinkedList linkedList) {
        this.exp = linkedList;
    }

    public void setPending(boolean bl) {
        this.pending = bl;
    }

    public boolean isPending() {
        return this.pending;
    }

    public void setRow(int n) {
        this.row = n;
    }

    public void setCol(int n) {
        this.col = n;
    }

    public boolean hasValue() {
        return this.type == 6 || this.type == 1 || this.type == 2 || this.type == 3 || this.type == 5;
    }

    public String toString() {
        switch (this.type) {
            case 6: {
                return Float.toString(this.number);
            }
            case 1: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('(');
                stringBuffer.append(String.valueOf(this.col));
                stringBuffer.append(',');
                stringBuffer.append(this.row);
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('$');
                stringBuffer.append(Node.translateColumn(this.col));
                stringBuffer.append('$');
                stringBuffer.append(Node.translateRow(this.row));
                return stringBuffer.toString();
            }
            case 3: {
                return this.data + this.exp.toString();
            }
            case 10: {
                return this.exp.toString();
            }
            case 4: {
                return "(";
            }
            case 5: {
                return ")";
            }
            case 8: {
                return ",";
            }
            case 9: {
                return this.nextRange.toString() + ":" + this.nextRange.nextRange.toString();
            }
        }
        return this.data;
    }

    public static int translateRow(String string) {
        int n = Integer.parseInt(string);
        return n + SharpTools.baseRow - 1;
    }

    public static String translateRow(int n) {
        if (n < 0) {
            return null;
        }
        return String.valueOf(n + 1 - SharpTools.baseRow);
    }

    public static int translateColumn(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            n = n * 26 + (string.charAt(n2) - 65 + 1);
            ++n2;
        }
        return n + SharpTools.baseCol - 1;
    }

    public static String translateColumn(int n) {
        if ((n = n - SharpTools.baseCol + 1) < 1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n2 = 1;
        while (n2 > 0) {
            n2 = (n - 1) / 26;
            stringBuffer.append((char)(65 + (n - n2 * 26 - 1)));
            stringBuffer.append(string);
            string = stringBuffer.toString();
            n = n2;
        }
        return string;
    }

    public CellPoint toCellPoint(int n, int n2) {
        if (this.isType(1)) {
            return new CellPoint(this.getRow() + n, this.getCol() + n2);
        }
        return new CellPoint(this.getRow(), this.getCol());
    }

    private static int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    private static int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public CellPoint[] getAddressRange(int n, int n2) {
        CellPoint[] cellPointArray = new CellPoint[2];
        if (this.isType(9)) {
            CellPoint cellPoint = this.getNextRange().toCellPoint(n, n2);
            CellPoint cellPoint2 = this.getNextRange().getNextRange().toCellPoint(n, n2);
            cellPointArray[0] = new CellPoint(Node.min(cellPoint.getRow(), cellPoint2.getRow()), Node.min(cellPoint.getCol(), cellPoint2.getCol()));
            cellPointArray[1] = new CellPoint(Node.max(cellPoint.getRow(), cellPoint2.getRow()), Node.max(cellPoint.getCol(), cellPoint2.getCol()));
        } else {
            CellPoint cellPoint;
            cellPointArray[0] = cellPoint = this.toCellPoint(n, n2);
            cellPointArray[1] = cellPoint;
        }
        return cellPointArray;
    }
}

