/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SharpTableModel
extends DefaultTableModel {
    private boolean modified;
    private boolean passwordModified;
    private SharpTools sharp;
    private History history;
    static /* synthetic */ Class class$Cell;

    public SharpTableModel(SharpTools sharpTools) {
        this.modified = false;
        this.sharp = sharpTools;
    }

    public SharpTableModel(SharpTools sharpTools, int n, int n2) {
        super(n, n2 + 1);
        int n3 = SharpTools.baseRow;
        while (n3 < n) {
            Cell cell = new Cell(new Integer(n3 + 1));
            super.setValueAt(cell, n3, 0);
            ++n3;
        }
        int n4 = SharpTools.baseRow;
        while (n4 < n) {
            int n5 = SharpTools.baseCol;
            while (n5 < n2 + 1) {
                super.setValueAt(new Cell(""), n4, n5);
                ++n5;
            }
            ++n4;
        }
        this.modified = false;
        this.sharp = sharpTools;
    }

    public SharpTableModel(SharpTools sharpTools, Object[][] objectArray) {
        this(sharpTools, objectArray.length + SharpTools.baseRow, objectArray[0].length + SharpTools.baseCol);
        int n = SharpTools.baseRow;
        while (n < objectArray.length) {
            int n2 = SharpTools.baseCol;
            while (n2 < objectArray[n].length) {
                this.doSetValueAt(objectArray[n][n2], n, n2);
                ++n2;
            }
            ++n;
        }
        this.modified = false;
        this.sharp = sharpTools;
    }

    public String getColumnName(int n) {
        Debug.println("name of column " + n);
        if (n < SharpTools.baseCol) {
            return "";
        }
        return String.valueOf(Node.translateColumn(n));
    }

    void setHistory(History history) {
        this.history = history;
    }

    public Cell getCellAt(int n, int n2) {
        if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return null;
        }
        Cell cell = (Cell)super.getValueAt(n, n2);
        return cell;
    }

    public Object getValueAt(int n, int n2) {
        return this.getCellAt(n, n2);
    }

    public void recalculate(int n, int n2) {
        if (this.isFormula(n, n2)) {
            try {
                Debug.println("recalculate");
                Number number = Formula.evaluate(this, n, n2);
                this.getCellAt(n, n2).setValue(number);
            }
            catch (ParserException parserException) {
                this.getCellAt(n, n2).setValue(parserException);
            }
        }
    }

    public void recalculate(CellPoint cellPoint) {
        this.recalculate(cellPoint.getRow(), cellPoint.getCol());
    }

    private static Object fieldParser(String string, CellPoint cellPoint) {
        if (string == null) {
            return new String("");
        }
        int n = cellPoint.getRow();
        int n2 = cellPoint.getCol();
        if (string.startsWith("=")) {
            Object var4_4 = null;
            try {
                return new Formula(string.substring(1), n, n2);
            }
            catch (ParserException parserException) {
                return new Formula(string.substring(1), n, n2, parserException);
            }
        }
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public static Object fieldParser(String string) {
        if (string == null) {
            return new String("");
        }
        try {
            return new Float(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        CellPoint cellPoint = new CellPoint(n, n2);
        this.history.add(this, new CellRange(cellPoint, cellPoint));
        this.doSetValueAt(object, n, n2);
    }

    public void doSetValueAt(Object object, int n, int n2) {
        if (object == null) {
            object = new String("");
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("=")) {
                Formula formula = null;
                try {
                    formula = new Formula(string.substring(1), n, n2);
                    this.setCellAt(formula, n, n2);
                }
                catch (ParserException parserException) {
                    formula = new Formula(string.substring(1), n, n2, parserException);
                    this.setCellAt(formula, n, n2);
                    this.getCellAt(n, n2).setValue(parserException);
                }
            } else {
                try {
                    Float f = new Float(string);
                    this.setCellAt(f, n, n2);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setCellAt(object, n, n2);
                }
            }
        } else if (object instanceof Formula) {
            try {
                Formula formula = (Formula)object;
                this.setCellAt(new Formula(formula, n, n2), n, n2);
            }
            catch (ParserException parserException) {
                Formula formula = (Formula)object;
                formula = new Formula(formula.toString(), n, n2, parserException);
                this.setCellAt(formula, n, n2);
                this.getCellAt(n, n2).setValue(parserException);
            }
        } else {
            this.setCellAt(object, n, n2);
        }
    }

    public void setCellAt(Object object, int n, int n2) {
        Cell cell = this.getCellAt(n, n2);
        if (cell != null) {
            this.removeRefs(n, n2);
            if (object instanceof Formula) {
                cell.setFormula((Formula)object);
                if (this.isLoop(new CellPoint(n, n2))) {
                    ParserException parserException = new ParserException("#LOOP?");
                    Formula formula = new Formula(object.toString(), n, n2, parserException);
                    this.setCellAt(formula, n, n2);
                    this.getCellAt(n, n2).setValue(parserException);
                    this.updateRefs(n, n2);
                    return;
                }
                this.addRefs(n, n2);
                this.recalculate(n, n2);
                this.updateRefs(n, n2);
            } else {
                cell.setData(object);
                this.updateRefs(n, n2);
            }
        }
    }

    public void setRange(CellRange cellRange, Object[][] objectArray) {
        int n = cellRange.getStartRow();
        while (n <= cellRange.getEndRow()) {
            int n2 = cellRange.getStartCol();
            while (n2 <= cellRange.getEndCol()) {
                int n3 = n - cellRange.getStartRow();
                int n4 = n2 - cellRange.getStartCol();
                this.doSetValueAt(objectArray[n3][n4], n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public void setRange(CellRange cellRange, Cell[][] cellArray, boolean bl) {
        if (bl) {
            int n = cellRange.getStartRow();
            while (n <= cellRange.getEndRow()) {
                int n2 = cellRange.getStartCol();
                while (n2 <= cellRange.getEndCol()) {
                    int n3 = n - cellRange.getStartRow();
                    int n4 = n2 - cellRange.getStartCol();
                    this.doSetValueAt(cellArray[n3][n4].getValue(), n, n2);
                    ++n2;
                }
                ++n;
            }
        } else {
            int n = cellRange.getStartRow();
            while (n <= cellRange.getEndRow()) {
                int n5 = cellRange.getStartCol();
                while (n5 <= cellRange.getEndCol()) {
                    int n6;
                    int n7 = n - cellRange.getStartRow();
                    Cell cell = cellArray[n7][n6 = n5 - cellRange.getStartCol()];
                    if (cell.isFormula()) {
                        this.doSetValueAt(cell.getFormula(), n, n5);
                    } else {
                        this.doSetValueAt(cell.getValue(), n, n5);
                    }
                    ++n5;
                }
                ++n;
            }
        }
    }

    public void clearRange(CellRange cellRange) {
        this.fill(cellRange, null);
    }

    protected void fillRange(CellRange cellRange, String string) {
        this.fill(cellRange, SharpTableModel.fieldParser(string, cellRange.getminCorner()));
    }

    protected void fill(CellRange cellRange, Object object) {
        int n = cellRange.getStartRow();
        while (n <= cellRange.getEndRow()) {
            int n2 = cellRange.getStartCol();
            while (n2 <= cellRange.getEndCol()) {
                this.doSetValueAt(object, n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public CellPoint look(CellPoint cellPoint, Object object, boolean bl, boolean bl2) {
        int n = cellPoint.getRow();
        int n2 = cellPoint.getCol();
        if (object instanceof String && !bl && bl2) {
            String string = (String)object;
            int n3 = n2;
            while (n3 < this.getColumnCount()) {
                if (string.equalsIgnoreCase(this.getCellAt(n, n3).getValue().toString())) {
                    return new CellPoint(n, n3);
                }
                ++n3;
            }
            int n4 = n + 1;
            while (n4 < this.getRowCount()) {
                int n5 = 1;
                while (n5 < this.getColumnCount()) {
                    if (string.equalsIgnoreCase(this.getCellAt(n4, n5).getValue().toString())) {
                        return new CellPoint(n4, n5);
                    }
                    ++n5;
                }
                ++n4;
            }
            return null;
        }
        if (object instanceof String && !bl2) {
            int n6;
            String string = (String)object;
            int n7 = n2;
            while (n7 < this.getColumnCount()) {
                String string2 = this.getCellAt(n, n7).getValue().toString();
                if (!bl) {
                    string = string.toUpperCase();
                    string2 = string2.toUpperCase();
                }
                n6 = 0;
                while (n6 < string2.length()) {
                    if (string2.startsWith(string, n6)) {
                        return new CellPoint(n, n7);
                    }
                    ++n6;
                }
                ++n7;
            }
            int n8 = n + 1;
            while (n8 < this.getRowCount()) {
                n6 = 1;
                while (n6 < this.getColumnCount()) {
                    String string3 = this.getCellAt(n8, n6).getValue().toString();
                    if (!bl) {
                        string = string.toUpperCase();
                        string3 = string3.toUpperCase();
                    }
                    int n9 = 0;
                    while (n9 < string3.length()) {
                        if (string3.startsWith(string, n9)) {
                            return new CellPoint(n8, n6);
                        }
                        ++n9;
                    }
                    ++n6;
                }
                ++n8;
            }
            return null;
        }
        int n10 = n2;
        while (n10 < this.getColumnCount()) {
            if (object.equals(this.getCellAt(n, n10).getValue())) {
                return new CellPoint(n, n10);
            }
            ++n10;
        }
        int n11 = n + 1;
        while (n11 < this.getRowCount()) {
            int n12 = 1;
            while (n12 < this.getColumnCount()) {
                if (object.equals(this.getCellAt(n11, n12).getValue())) {
                    return new CellPoint(n11, n12);
                }
                ++n12;
            }
            ++n11;
        }
        return null;
    }

    public Cell[][] getRange(CellRange cellRange) {
        Cell[][] cellArray = new Cell[cellRange.getHeight()][cellRange.getWidth()];
        int n = cellRange.getStartRow();
        while (n <= cellRange.getEndRow()) {
            int n2 = cellRange.getStartCol();
            while (n2 <= cellRange.getEndCol()) {
                int n3 = n - cellRange.getStartRow();
                int n4 = n2 - cellRange.getStartCol();
                Cell cell = this.getCellAt(n, n2);
                if (cell.isFormula()) {
                    try {
                        Formula formula = new Formula(cell.getFormula(), n, n2);
                        cellArray[n3][n4] = new Cell(formula, cell.getValue(), null);
                    }
                    catch (ParserException parserException) {
                        cellArray[n3][n4] = new Cell(cell.getFormula().toString());
                    }
                } else {
                    cellArray[n3][n4] = new Cell(cell.getValue());
                }
                ++n2;
            }
            ++n;
        }
        return cellArray;
    }

    public void addRefs(int n, int n2) {
        if (this.isFormula(n, n2)) {
            Formula formula = this.getCellAt(n, n2).getFormula();
            TreeSet treeSet = formula.getDependency();
            Iterator iterator = treeSet.iterator();
            CellPoint cellPoint = new CellPoint(n, n2);
            while (iterator.hasNext()) {
                CellPoint cellPoint2 = (CellPoint)iterator.next();
                Cell cell = this.getCellAt(cellPoint2.getRow(), cellPoint2.getCol());
                if (cell == null) continue;
                cell.addRef(cellPoint);
            }
        }
    }

    public void removeRefs(int n, int n2) {
        if (this.isFormula(n, n2)) {
            Formula formula = this.getCellAt(n, n2).getFormula();
            TreeSet treeSet = formula.getDependency();
            Iterator iterator = treeSet.iterator();
            CellPoint cellPoint = new CellPoint(n, n2);
            while (iterator.hasNext()) {
                CellPoint cellPoint2 = (CellPoint)iterator.next();
                Cell cell = this.getCellAt(cellPoint2.getRow(), cellPoint2.getCol());
                if (cell == null) continue;
                cell.removeRef(cellPoint);
            }
        }
    }

    public void updateRefs(int n, int n2) {
        CellPoint cellPoint;
        Cell cell = this.getCellAt(n, n2);
        if (cell == null) {
            return;
        }
        TreeSet treeSet = this.getRefs(n, n2);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            cellPoint = (CellPoint)iterator.next();
            Formula formula = this.getCellAt(cellPoint.getRow(), cellPoint.getCol()).getFormula();
            formula.setNeedsRecalc(true);
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            cellPoint = (CellPoint)iterator.next();
            try {
                this.getNumericValueAt(cellPoint.getRow(), cellPoint.getCol());
            }
            catch (ParserException parserException) {
                // empty catch block
            }
            this.fireTableCellUpdated(cellPoint.getRow(), cellPoint.getCol());
        }
        this.fireTableCellUpdated(n, n2);
    }

    private TreeSet getRefs(int n, int n2) {
        TreeSet treeSet = new TreeSet();
        this.getRefs(n, n2, treeSet);
        return treeSet;
    }

    private void getRefs(int n, int n2, TreeSet treeSet) {
        Cell cell = this.getCellAt(n, n2);
        if (cell == null || !cell.hasRefs()) {
            return;
        }
        Iterator iterator = cell.getRefs().iterator();
        while (iterator.hasNext()) {
            CellPoint cellPoint = (CellPoint)iterator.next();
            treeSet.add(cellPoint);
            this.getRefs(cellPoint.getRow(), cellPoint.getCol(), treeSet);
        }
    }

    public void recalculateAll() {
        int n = 1;
        while (n < this.getRowCount()) {
            int n2 = 1;
            while (n2 < this.getColumnCount()) {
                this.addRefs(n, n2);
                this.recalculate(n, n2);
                ++n2;
            }
            ++n;
        }
    }

    public void removeColumn(CellRange cellRange) {
        int n = cellRange.getStartCol();
        int n2 = cellRange.getWidth();
        int n3 = this.getRowCount() - 1;
        int n4 = this.getColumnCount() - 1;
        CellRange cellRange2 = new CellRange(SharpTools.baseRow, n3, n + n2, n4);
        SharpClipboard sharpClipboard = new SharpClipboard(this, cellRange2, true);
        JTable jTable = this.sharp.getTable();
        int n5 = 0;
        while (n5 < n2) {
            this.removeColumn();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            tableColumnModel.removeColumn(tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1));
            ++n5;
        }
        sharpClipboard.paste(this, new CellPoint(SharpTools.baseRow, n));
        this.recalculateAll();
        if (jTable.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(SharpTools.baseRow, SharpTools.baseRow, n, n));
        }
        this.sharp.setBaseColumnWidth();
    }

    private void removeColumn() {
        int n = this.getRowCount() - 1;
        int n2 = this.getColumnCount() - 1;
        this.clearRange(new CellRange(SharpTools.baseRow, n, n2, n2));
        Iterator iterator = this.dataVector.iterator();
        while (iterator.hasNext()) {
            Vector vector = (Vector)iterator.next();
            vector.removeElementAt(this.getColumnCount() - 1);
        }
        this.columnIdentifiers.removeElementAt(this.columnIdentifiers.size() - 1);
    }

    public void insertColumn(CellRange cellRange) {
        Debug.println("insertRange: " + cellRange);
        int n = cellRange.getStartCol();
        int n2 = cellRange.getWidth();
        int n3 = this.getRowCount() - 1;
        int n4 = this.getColumnCount() - 1;
        CellRange cellRange2 = new CellRange(SharpTools.baseRow, n3, Math.max(n, SharpTools.baseCol), n4);
        SharpClipboard sharpClipboard = new SharpClipboard(this, cellRange2, true);
        JTable jTable = this.sharp.getTable();
        int n5 = 0;
        while (n5 < n2) {
            this.addColumn();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(tableColumnModel.getColumnCount() - 1);
            TableColumn tableColumn2 = new TableColumn(tableColumnModel.getColumnCount(), tableColumn.getPreferredWidth());
            tableColumn2.setHeaderValue(new Character((char)(65 + n4 + 1 + n5)));
            tableColumnModel.addColumn(tableColumn2);
            ++n5;
        }
        sharpClipboard.paste(this, new CellPoint(SharpTools.baseRow, n + n2));
        this.recalculateAll();
        if (jTable.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(SharpTools.baseRow, SharpTools.baseRow, n, n));
        }
        this.sharp.setBaseColumnWidth();
    }

    private void addColumn() {
        this.columnIdentifiers.addElement(null);
        Iterator iterator = this.dataVector.iterator();
        if (iterator.hasNext()) {
            Cell cell = new Cell(Node.translateColumn(this.getColumnCount() - 1));
            ((Vector)iterator.next()).addElement(cell);
        }
        while (iterator.hasNext()) {
            ((Vector)iterator.next()).addElement(new Cell(""));
        }
    }

    public void removeRow(CellRange cellRange) {
        this.clearRange(cellRange);
        int n = cellRange.getStartRow();
        int n2 = cellRange.getHeight();
        int n3 = this.getRowCount() - 1;
        int n4 = this.getColumnCount() - 1;
        CellRange cellRange2 = new CellRange(n + n2, n3, SharpTools.baseCol, n4);
        SharpClipboard sharpClipboard = new SharpClipboard(this, cellRange2, true);
        int n5 = 0;
        while (n5 < n2) {
            super.removeRow(this.getRowCount() - 1);
            ++n5;
        }
        sharpClipboard.paste(this, new CellPoint(n, SharpTools.baseCol));
        this.recalculateAll();
        JTable jTable = this.sharp.getTable();
        if (jTable.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(n, n, SharpTools.baseCol, SharpTools.baseCol));
        }
    }

    public void insertRow(CellRange cellRange) {
        int n = cellRange.getStartRow();
        int n2 = cellRange.getHeight();
        int n3 = this.getRowCount() - 1;
        int n4 = this.getColumnCount() - 1;
        CellRange cellRange2 = new CellRange(Math.max(n, SharpTools.baseRow), n3, SharpTools.baseCol, n4);
        SharpClipboard sharpClipboard = new SharpClipboard(this, cellRange2, true);
        int n5 = 0;
        while (n5 < n2) {
            this.addRow();
            ++n5;
        }
        sharpClipboard.paste(this, new CellPoint(n + n2, SharpTools.baseCol));
        this.recalculateAll();
        JTable jTable = this.sharp.getTable();
        if (jTable.getSelectedColumnCount() == 0) {
            this.setSelection(new CellRange(n, n, SharpTools.baseCol, SharpTools.baseCol));
        }
    }

    private void addRow() {
        Vector<Cell> vector = new Vector<Cell>();
        vector.add(0, new Cell(new Integer(this.getRowCount() + 1)));
        super.addRow(vector);
        int n = 1;
        while (n < this.getColumnCount()) {
            super.setValueAt(new Cell(""), this.getRowCount() - 1, n);
            ++n;
        }
    }

    public Number getNumericValueAt(int n, int n2) throws ParserException {
        Cell cell = this.getCellAt(n, n2);
        if (cell != null) {
            int n3 = cell.getType();
            if (n3 == 2) {
                Object object = cell.getValue();
                Formula formula = cell.getFormula();
                if (formula.needsRecalc()) {
                    try {
                        object = Formula.evaluate(this, n, n2);
                        cell.setValue(object);
                    }
                    catch (ParserException parserException) {
                        cell.setValue(parserException);
                        object = parserException;
                    }
                }
                if (object instanceof ParserException) {
                    throw (ParserException)object;
                }
                return (Number)cell.getValue();
            }
            if (n3 == 1) {
                return (Number)cell.getValue();
            }
            return new Float(0.0f);
        }
        throw new ParserException("#REFS?");
    }

    public boolean isFormula(int n, int n2) {
        Cell cell = this.getCellAt(n, n2);
        return cell != null && cell.getType() == 2;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    public Class getColumnClass(int n) {
        return class$Cell == null ? (class$Cell = SharpTableModel.class$("Cell")) : class$Cell;
    }

    private boolean isLoop(CellPoint cellPoint) {
        return this.isLoop(cellPoint, new TreeSet());
    }

    private boolean isLoop(CellPoint cellPoint, TreeSet treeSet) {
        if (treeSet.contains(cellPoint)) {
            return true;
        }
        Cell cell = this.getCellAt(cellPoint.getRow(), cellPoint.getCol());
        if (cell == null) {
            return false;
        }
        Formula formula = cell.getFormula();
        if (formula == null) {
            return false;
        }
        treeSet.add(cellPoint);
        Iterator iterator = formula.getDependency().iterator();
        while (iterator.hasNext()) {
            CellPoint cellPoint2 = (CellPoint)iterator.next();
            boolean bl = this.isLoop(cellPoint2, treeSet);
            if (!bl) continue;
            return true;
        }
        treeSet.remove(cellPoint);
        return false;
    }

    public void setModified(boolean bl) {
        this.modified = bl | this.passwordModified;
        this.sharp.checkSaveState();
    }

    public void setPasswordModified(boolean bl) {
        this.passwordModified = bl;
        this.setModified(this.modified);
    }

    public boolean isModified() {
        return this.modified;
    }

    public JTable getTable() {
        return this.sharp.getTable();
    }

    public void setSelection(CellRange cellRange) {
        JTable jTable = this.sharp.getTable();
        int n = jTable.getRowCount() - 1;
        int n2 = jTable.getColumnCount() - 1;
        int n3 = cellRange.getStartRow();
        int n4 = cellRange.getStartCol();
        int n5 = cellRange.getEndRow();
        int n6 = cellRange.getEndCol();
        jTable.setColumnSelectionInterval(Math.min(n4, n2), Math.min(n6, n2));
        jTable.setRowSelectionInterval(Math.min(n3, n), Math.min(n5, n));
    }

    public boolean isDeletionSafe(CellRange cellRange, boolean bl) {
        CellRange cellRange2;
        int n;
        int n2;
        if (bl) {
            n2 = -cellRange.getHeight();
            n = 0;
            if (cellRange.getEndRow() == this.getRowCount() - 1) {
                return true;
            }
            cellRange2 = new CellRange(cellRange.getEndRow() + 1, this.getRowCount() - 1, SharpTools.baseCol, this.getColumnCount() - 1);
        } else {
            n2 = 0;
            n = -cellRange.getWidth();
            if (cellRange.getEndCol() == this.getColumnCount() - 1) {
                return true;
            }
            cellRange2 = new CellRange(SharpTools.baseRow, this.getRowCount() - 1, cellRange.getEndCol() + 1, this.getColumnCount() - 1);
        }
        int n3 = cellRange2.getStartRow();
        while (n3 <= cellRange2.getEndRow()) {
            int n4 = cellRange2.getStartCol();
            while (n4 <= cellRange2.getEndCol()) {
                Cell cell = this.getCellAt(n3, n4);
                if (cell.isFormula() && !Formula.isSafe(cell.getFormula(), n2, n)) {
                    Debug.println("relative addresses become invalid");
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public String toString(CellRange cellRange, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = cellRange.getStartRow();
        while (n <= cellRange.getEndRow()) {
            int n2 = cellRange.getStartCol();
            while (n2 <= cellRange.getEndCol()) {
                if (bl) {
                    stringBuffer.append(this.getValueAt(n, n2));
                } else {
                    Cell cell = this.getCellAt(n, n2);
                    if (cell != null) {
                        stringBuffer.append(cell.toString());
                    }
                }
                if (n2 < cellRange.getEndCol()) {
                    stringBuffer.append("\t");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        String string = stringBuffer.toString();
        return string;
    }

    void fromString(String string, int n, int n2, CellRange cellRange) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            int n3 = cellRange.getStartRow();
            while (n3 <= cellRange.getEndRow()) {
                String string2 = bufferedReader.readLine();
                int n4 = 0;
                int n5 = cellRange.getStartCol();
                while (n5 <= cellRange.getEndCol()) {
                    int n6 = string2.indexOf(9, n4);
                    String string3 = n6 >= 0 ? string2.substring(n4, n6) : string2.substring(n4);
                    if (string3.startsWith("=")) {
                        string3 = (string3 = Formula.fixRelAddr(string3.substring(1), n, n2)) == null ? new String("=$REFS$0") : "=" + string3;
                    }
                    this.doSetValueAt(string3, n3, n5);
                    n4 = n6 + 1;
                    ++n5;
                    if (n6 == -1) break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return this.toString(new CellRange(SharpTools.baseRow, this.getRowCount() - 1, SharpTools.baseCol, this.getColumnCount() - 1), false);
    }

    public static CellPoint getSize(String string) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        int n = 0;
        int n2 = 0;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n3;
                ++n;
                int n4 = 0;
                int n5 = 0;
                do {
                    n3 = string2.indexOf(9, n4);
                    n4 = n3 + 1;
                    ++n5;
                } while (n3 != -1);
                if (n2 >= n5) continue;
                n2 = n5;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return new CellPoint(n, n2);
    }

    public void sort(CellRange cellRange, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        CellRange cellRange2;
        int n3;
        SharpClipboard[] sharpClipboardArray;
        if (bl) {
            sharpClipboardArray = new SharpClipboard[cellRange.getWidth()];
            n3 = 0;
            while (n3 < sharpClipboardArray.length) {
                cellRange2 = new CellRange(cellRange.getStartRow(), cellRange.getEndRow(), cellRange.getStartCol() + n3, cellRange.getStartCol() + n3);
                sharpClipboardArray[n3] = new SharpClipboard(this, cellRange2, false);
                ++n3;
            }
        } else {
            sharpClipboardArray = new SharpClipboard[cellRange.getHeight()];
            n3 = 0;
            while (n3 < sharpClipboardArray.length) {
                cellRange2 = new CellRange(cellRange.getStartRow() + n3, cellRange.getStartRow() + n3, cellRange.getStartCol(), cellRange.getEndCol());
                sharpClipboardArray[n3] = new SharpClipboard(this, cellRange2, false);
                ++n3;
            }
        }
        int[] nArray = this.internalSort(cellRange, n, n2, bl, bl2, bl3);
        if (bl) {
            int n4 = cellRange.getStartCol();
            while (n4 <= cellRange.getEndCol()) {
                CellPoint cellPoint = new CellPoint(cellRange.getStartRow(), n4);
                int n5 = n4 - cellRange.getStartCol();
                sharpClipboardArray[nArray[n5] - cellRange.getStartCol()].paste(this, cellPoint);
                ++n4;
            }
        } else {
            int n6 = cellRange.getStartRow();
            while (n6 <= cellRange.getEndRow()) {
                CellPoint cellPoint = new CellPoint(n6, cellRange.getStartCol());
                int n7 = n6 - cellRange.getStartRow();
                sharpClipboardArray[nArray[n7] - cellRange.getStartRow()].paste(this, cellPoint);
                ++n6;
            }
        }
    }

    private int compareLines(int n, boolean bl, boolean bl2, int n2, int n3) {
        Cell cell = this.getCriteria(n, n2, bl);
        Cell cell2 = this.getCriteria(n, n3, bl);
        return cell.compare(cell2, bl2);
    }

    private Cell getCriteria(int n, int n2, boolean bl) {
        if (bl) {
            return this.getCellAt(n, n2);
        }
        return this.getCellAt(n2, n);
    }

    private boolean rightOrder(int n, int n2, boolean bl, int n3, int n4, boolean bl2, boolean bl3) {
        int n5 = this.compareLines(n, bl, bl2, n3, n4);
        if (n5 == 0) {
            n5 = this.compareLines(n2, bl, bl3, n3, n4);
            if (bl3) {
                return n5 < 0;
            }
            return n5 > 0;
        }
        if (bl2) {
            return n5 < 0;
        }
        return n5 > 0;
    }

    private int[] internalSort(CellRange cellRange, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int[] nArray;
        if (bl) {
            nArray = new int[cellRange.getWidth()];
            n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3 + cellRange.getStartCol();
                ++n3;
            }
        } else {
            nArray = new int[cellRange.getHeight()];
            n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3 + cellRange.getStartRow();
                ++n3;
            }
        }
        int n4 = 1;
        while (n4 < nArray.length) {
            int n5 = nArray[n4];
            n3 = n4;
            while (n3 > 0 && this.rightOrder(n, n2, bl, n5, nArray[n3 - 1], bl2, bl3)) {
                nArray[n3] = nArray[n3 - 1];
                --n3;
            }
            nArray[n3] = n5;
            ++n4;
        }
        return nArray;
    }

    public boolean isEmptyCell(int n, int n2) {
        return this.getCellAt(n, n2).getValue().equals("");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

