/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class TableOp
implements ActionListener {
    private SharpTools sharp;
    private JTable table;
    private SharpTableModel tableModel;
    private History history;
    private JToolBar toolBar;
    private static final ImageIcon colwidthIcon = SharpTools.getImageIcon("colwidth.gif");

    TableOp(SharpTools sharpTools) {
        this.init(sharpTools);
        sharpTools.checkFindNextState();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(155, 2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(155, 3, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(127, 2, false);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(127, 3, false);
        this.table.registerKeyboardAction(this, "Insert Row", keyStroke, 0);
        this.table.registerKeyboardAction(this, "Insert Column", keyStroke2, 0);
        this.table.registerKeyboardAction(this, "Delete Row", keyStroke3, 0);
        this.table.registerKeyboardAction(this, "Delete Column", keyStroke4, 0);
    }

    private void init(SharpTools sharpTools) {
        this.sharp = sharpTools;
        this.table = sharpTools.getTable();
        this.tableModel = sharpTools.getTableModel();
        this.history = sharpTools.getHistory();
        this.toolBar = sharpTools.getToolBar();
    }

    public void insert(boolean bl) {
        int n = this.table.getSelectedRowCount();
        if (n != 0) {
            if (bl) {
                int n2 = this.table.getSelectedRow();
                CellRange cellRange = new CellRange(new CellPoint(n2, SharpTools.baseCol), new CellPoint(n2 + n - 1, this.tableModel.getColumnCount() - 1));
                this.history.add(this.tableModel, cellRange, 1);
                this.tableModel.insertRow(cellRange);
            } else {
                n = this.table.getSelectedColumnCount();
                int n3 = this.table.getSelectedColumn();
                CellRange cellRange = new CellRange(new CellPoint(SharpTools.baseRow, n3), new CellPoint(this.tableModel.getRowCount() - 1, n3 + n - 1));
                this.history.add(this.tableModel, cellRange, 2);
                this.tableModel.insertColumn(cellRange);
            }
        } else {
            this.sharp.noCellsSelected("Insert");
        }
    }

    public void remove(boolean bl) {
        int n = this.table.getSelectedRowCount();
        if (n != 0) {
            if (bl) {
                if (n == this.table.getRowCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                int n2 = this.table.getSelectedRow();
                CellRange cellRange = new CellRange(new CellPoint(n2, SharpTools.baseCol), new CellPoint(n2 + n - 1, this.tableModel.getColumnCount() - 1));
                if (this.tableModel.isDeletionSafe(cellRange, true) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, cellRange, 3);
                    Debug.println(cellRange);
                    this.tableModel.removeRow(cellRange);
                    Debug.println("Delete row range " + cellRange);
                }
            } else {
                int n3 = this.table.getSelectedColumn();
                n = this.table.getSelectedColumnCount();
                if (n == this.table.getColumnCount() - 1) {
                    this.tooMuchDeletion();
                    return;
                }
                CellRange cellRange = new CellRange(new CellPoint(SharpTools.baseRow, n3), new CellPoint(this.tableModel.getRowCount() - 1, n3 + n - 1));
                Debug.println("Delete column range " + cellRange);
                if (this.tableModel.isDeletionSafe(cellRange, false) || this.unsafeDeletion()) {
                    this.history.add(this.tableModel, cellRange, 4);
                    Debug.println(cellRange);
                    this.tableModel.removeColumn(cellRange);
                }
            }
        } else {
            this.sharp.noCellsSelected("Remove");
        }
    }

    public void sort(boolean bl) {
        if (this.table.getSelectedRowCount() != 0) {
            int n;
            CellRange cellRange = new CellRange(this.table.getSelectedRows(), this.table.getSelectedColumns());
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            vector2.add("None");
            if (bl) {
                n = cellRange.getStartRow();
                while (n <= cellRange.getEndRow()) {
                    vector.add("Row " + Node.translateRow(n));
                    vector2.add("Row " + Node.translateRow(n));
                    ++n;
                }
            } else {
                n = cellRange.getStartCol();
                while (n <= cellRange.getEndCol()) {
                    vector.add("Column " + Node.translateColumn(n));
                    vector2.add("Column " + Node.translateColumn(n));
                    ++n;
                }
            }
            SortDialog sortDialog = new SortDialog(this.sharp, vector, vector2);
            sortDialog.pack();
            sortDialog.setLocationRelativeTo(this.sharp);
            sortDialog.setVisible(true);
            Debug.println("Here we go " + sortDialog.getCriteriaA() + ": And : " + sortDialog.getCriteriaB());
            Debug.println(sortDialog.firstAscending() + " : " + sortDialog.secondAscending());
            int n2 = sortDialog.getCriteriaA();
            if (n2 >= 0) {
                this.history.add(this.tableModel, cellRange);
                n2 = bl ? (n2 += cellRange.getStartRow()) : (n2 += cellRange.getStartCol());
                int n3 = sortDialog.getCriteriaB();
                if (n3 > 0) {
                    n3 = bl ? (n3 += cellRange.getStartRow() - 1) : (n3 += cellRange.getStartCol() - 1);
                    this.tableModel.sort(cellRange, n2, n3, bl, sortDialog.firstAscending(), sortDialog.secondAscending());
                } else {
                    this.tableModel.sort(cellRange, n2, n2, bl, sortDialog.firstAscending(), sortDialog.secondAscending());
                }
            }
        } else {
            this.sharp.noCellsSelected("Sort");
        }
    }

    public void setColumnWidth() {
        int n = SharpTools.getConfig().getInt("COLUMNWIDTH");
        Integer n2 = SharpOptionPane.showIntegerInputDialog(this.sharp, "Please input the column width in pixels: ", "Column Width", 3, colwidthIcon, new Integer(n));
        if (n2 != null) {
            try {
                int n3 = n2;
                if (n3 != n && n3 >= 0) {
                    SharpTools.getConfig().setInt("COLUMNWIDTH", n3);
                    this.sharp.setColumnWidth(n3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean unsafeDeletion() {
        int n = SharpOptionPane.showOptionDialog(this.sharp, "The deletion may cause irriversible data loss in other cells.\n\nDo you really want to proceed?\n\n", "Delete", 0, 2, null, 1);
        return n == 0;
    }

    private void tooMuchDeletion() {
        SharpOptionPane.showMessageDialog(this.sharp, "You can not delete all the rows or columns!", "Delete", 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().compareTo("Insert Row") == 0) {
            this.insert(true);
        } else if (actionEvent.getActionCommand().compareTo("Insert Column") == 0) {
            this.insert(false);
        } else if (actionEvent.getActionCommand().compareTo("Delete Row") == 0) {
            this.remove(true);
        } else if (actionEvent.getActionCommand().compareTo("Delete Column") == 0) {
            this.remove(false);
        }
    }
}

