$!-----------------------------------------------------------------------------
$! UPDATESSL.COM
$!
$! WASD VMS Hypertext Services, Copyright (C) 1996-2002 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Update the WASD Hypertext Services SSL HTTPd and applications.
$! *** MUST BE CALLED FROM UPDATE.COM! ***
$!
$! 01-AUG-2002  MGD  change back to "JUST:SESOLA" for v7.n compatibility
$! 08-JUL-2002  MGD  v8.0, change to "@BUILD_HTTPD SSL JUST:SSL"
$! 03-NOV-2001  MGD  v7.2.1, PERSONA_MACRO build
$! 07-APR-2001  MGD  [.SRC.HTTPD]BUILD_HTTPD.COM reworked
$! 12-SEP-2000  MGD  make OpenSSL directory finding a little more generic
$! 05-MAR-2000  MGD  OpenSSL 0.9.5,
$!                   bugfix; passing of 'OpenSSLdir' to BUILD_HTTPD.COM
$! 30-NOV-1999  MGD  v6.1, initial (allows the independant updating of the SSL
$!                         update procedure; e.g. after new version of OpenSSL)
$!-----------------------------------------------------------------------------
$!
$ if f$environment("depth") .le. 1
$ then
$    type SYS$INPUT

  *****************************************
  * Must be called from via $ @UPDATE SSL *
  *****************************************

$    exit %x10000000
$ endif
$!
$ archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$ if archName .eqs. "ALPHA" then archName = "AXP"
$ vmsVersion = f$getsyi("VERSION")
$ vmsVersion = f$integer(f$extract(1,1,vmsVersion)) * 10 +-
               f$integer(f$extract(3,1,vmsVersion))
$!
$ SSLroot = ""
$!(search for latest version in default WASD location)
$ sslRootLoop:
$    tmpDir = f$search("HT_ROOT:[SRC]OPENSSL-*_*_*.DIR")
$    if tmpDir .eqs. "" then goto end_sslRootLoop
$    sslDirPos = f$locate("]OPENSSL",tmpDir)
$    SSLroot = f$extract(0,sslDirPos,tmpDir) + "." + -
                  f$extract(sslDirPos+1,999,tmpDir) - ".DIR;1" + "]"
$    goto sslRootLoop
$ end_sslRootLoop:
$ if SSLroot .eqs. ""
$ then
$    type SYS$INPUT

  ************************************************************************
  * Cannot find supported OpenSSL directory: HT_ROOT:[SRC.OPENSSL-*_*_*] *
  ************************************************************************

$    exit %x10000000
$ endif
$!
$ type SYS$INPUT

--- BUILD SSL EXECUTABLES ---

| Two stages are undertaken at this step:
|   a. Build/Link the HTTPd.
|   b. Link OpenSSL applications.
| This will only work if the SSL package has been installed!
|  
| SSL HTTPd executable must be built.  This can be done two ways.
|   1. Compiling from source, then linking.       Respond: "Compile+link"
|   2. Linking separate package object modules.   Respond: "Link"
|   or skip this step                             Respond: "No"
| Build executable?
|
$ response = ""
$ read sys$command response /prompt="[No]: "
$ if response .eqs. "" then response = "No"
$ firstChar = f$edit(f$extract(0,1,response),"upcase")
$ if (firstChar .eqs. "C" .or. firstChar .eqs. "1" .or. -
      firstChar .eqs. "L" .or. firstChar .eqs. "2") .and. -
      archName .eqs. "VAX" .and. vmsVersion .lt. 62
$ then
$    type SYS$INPUT

| VAX VMS 6.0 and 6.1 do not support the $PERSONA system services.
| This imposes a restriction on non-server account scripting.
|
| A kernel-mode MACRO module can provide sufficient functionality to support
| non-server account scripting.  This module makes a momentary modification
| to the username in kernel process data structures.  Although this approach
| has been used by a number of tools and applications and has proved quite
| reliable it is still a mechanism unsupported by the operating system proper
| and so may have a (potentially) undesirable impact on system integrity.
| If unsure about the need for non-server account scripting or this topic
| in general please consult the WASD documentation before proceding.
|
| Build using the PERSONA_MACRO option?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response .eqs. "" then response = "No"
$    if response then BUILD_HTTPD_PERSONA_MACRO = 1
$ endif
$ if firstChar .eqs. "C" .or. firstChar .eqs. "1"
$ then
$    set default HT_ROOT:[SRC.HTTPD]
$    type SYS$INPUT

--- COMPILING SESOLA MODULE OF HTTPD ---

$    @BUILD_HTTPD SSL JUST:SESOLA
$!   'f$verify(0)
$ endif
$ if firstChar .eqs. "C" .or. firstChar .eqs. "L" .or. -
     firstChar .eqs. "1" .or. firstChar .eqs. "2"
$ then
$    set default HT_ROOT:[SRC.HTTPD]
$    type SYS$INPUT

--- LINKING SSL VERSION OF HTTPD ---

$    @BUILD_HTTPD SSL LINK
$!   'f$verify(0)
$    type SYS$INPUT

--- LINKING OPENSSL APPLICATIONS ---

$    set default 'SSLroot'
$    set default [.APPS]
$    @MAKEAPPS LINK
$    set default [-]
$ endif
$!
$ set default [000000]
$ exit %x00000001
$!-----------------------------------------------------------------------------
