O $!-----------------------------------------------------------------'f$verify(0)  $! CLIENT_CERT_REQUEST.COM $!F $! WASD VMS Hypertext Services, Copyright (c) 1996-2001 Mark G.Daniel.M $! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY. @ $! This is free software, and you are welcome to redistribute itE $! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.  $!: $! NOTE: This procedure is for experimental purposes only!= $!       It is not intended as a production script for a CA!!   $!       Use at your own risk!!! $!M $! The server account requires read+write access to the OpenSSL configuration J $! and certificate directories.  The easiest way to provide this with WASDI $! v7.1 and following is to enable /PERSONA and adding an HTTPD$MAP entry E $! directing this script should be executed using the SYSTEM account.  $!8 $!   set /cgi-bin/client_cert_request/* script=as=SYSTEM $!J $! This script will operate in one of two ways depending on configuration. $!2 $! AUTOMATIC CERT, ON-DEMAND, ON-LINE FOR ANY USER2 $! -----------------------------------------------H $! Automatically generating client certificates for any user, on-demand,1 $! online, over the Web using a Netscape browser.  $!O $! When the user accesses the script via a GET request it provides an HTML form L $! that allows a private-key and CSR to be submitted back to the script as aN $! POSTed request.  This is then processed by the OpenSSL CA utility to createD $! the certificate, which is the returned direct to the browser as aM $! "application/x-x509-user-cert" response.  The user would access the script ) $! using something like the following URL  $!2 $!   https://host.name/cgi-bin/client_cert_request $! $! Setup $! -----O $! Copy the procedure into HT_ROOT:[SCRIPT_LOCAL] with appropriate permissions.  $! $! In HTTPD$MAP  $!6 $!   set /cgi-bin/client_cert_request script=as=SYSTEM $! $!8 $! AUTOMATIC CSR FOR ANY USER, SITE ADMIN GENERATED CERT8 $! -----------------------------------------------------I $! By providing an interface and script for a user to generate a CSR and  M $! send that via email to the site administrator. Then for that administrator I $! to use the same script as an interface and script (under authorization ) $! controls) to generate the certificate.  $!  J $! When the user accesses the script via a GET request it provides an HTMLL $! form that allows a private-key and CSR to be submitted back to the scriptL $! as a POSTed request.  The fields are collated and this is then emailed toM $! a specified address. The user would access the script using something like  $! the following URL $!2 $!   https://host.name/cgi-bin/client_cert_request $!  M $! The site administartor access the script with an additional, authorization   $! controlled path.  For example $!  L $!   https://host.name/cgi-bin/client_cert_request/admin/client_cert_request $!  K $! The admin is provided with an HTML form that allows cut-and-paste of the L $! user CSR into a text area, duration in days is set, and the CA passphraseK $! entered, and then the form submitted.  The OpenSSL CA utility is used to J $! generate the certificate, which is placed in PEM format into the site's! $! certificate storage directory.  $!  O $! A page containing this PEM certificate is returned to he site administrator. K $! There is a URL at the top of the page.  This allows the user to download K $! the certificate into the browser.  This page may be emailed to the user.  $!   $! Setup $! -----O $! Copy the procedure into HT_ROOT:[SCRIPT_LOCAL] with appropriate permissions.  $! $! In HTTPD$AUTH $! $!   [whatever-realm] 6 $!   /admin/client_cert_request/* r+w,whatever-account $! $! In HTTPD$MAP  $!8 $!   set /cgi-bin/client_cert_request/* script=as=SYSTEM $! $! $! OTHER CONSIDERATIONS  $! -------------------- N $! When generating certificates the procedure requires write access to scratchN $! space.  By default either HT_ROOT:[SCRATCH] (v7.1.1 or later HT_SCRATCH) or! $! HT_ROOT:[LOGS.SERVER] is used.  $!K $! This script may be easily cloned - just copy it to a new procedure name! > $! To allow procedure problem resultuion define a logical nameI $! <procedure-name>$DEBUG.  For instance, for this original procedure the ! $! logical could be defined using  $!2 $!   $ DEFINE /SYSTEM CLIENT_CERT_REQUEST$DEBUG 1  $!  N $! ***** THIS HAS BEEN TESTED IN THE DEFAULT WASD OPENSSL DIRECTORY TREE *****8 $!                  MILEAGE MAY VARY USING OTHER SETUPS! $!   $! VERSION HISTORY $! ---------------   $! 18-DEC-2000  MGD  initialO $!-----------------------------------------------------------------------------  $! $! Configurable Parameters ... $!K $! Enabling this value allows users to generate client certificates on-line ; $! (provided the script is correctly configured of course). D $! Disabling this value allows them to generate a CSR which can thenH $! optionally be emailed to the site administrator who can then use this' $! same script to complete the process.  $! $ onDemandGenerate = 0 $ CSRemailAddress = "SYSTEM" $!L $! Leave these empty to have the procedure configure itself for the standardN $! WASD OpenSSL setup (HT_ROOT:[SRC.OPENSSL-n_n_n]).  If one is explicitly set $! all must be set.  $!C $ OpenSSLdir = ""            !top-level location of OpenSSL pacakge G $ certBinaryDir = ""         !location of generated binary certificates < $ defaultConfig = ""         !location of configuration fileB $ opensslEXE = ""            !foreign verb for OPENSSL.EXE programD $ scratchDir = ""            !directory the script can read+write toN $ CApassphrase = ""          !CA certificate password (only set for on-demand)< $ durationDays = "365"       !duration of client certificate $!O $!-----------------------------------------------------------------------------  $!
 $ set noon9 $ procName = f$parse(f$environment("procedure"),,,"name")  $ debug = procName + "$DEBUG"  $ debug = f$trnlnm(debug) 
 $ if debug $ then $    type sys$input  Content-Type: text/plain   $    show sym *  $    set verify  $ endif  $! $ say = "write sys$output"$ $ saysym = "write/symbol sys$output" $ lf[0,8] = 10 $ CGIutl = "$HT_EXE:CGIUTL" $ $ sysOutput = f$trnlnm("SYS$OUTPUT")" $ sysError = f$trnlnm("SYS$ERROR") $ NORMAL_STATUS = %x00000001 $ ERROR_STATUS = %x10000004  $!@ $ pathInfoAdmin = "/admin/" + f$edit(procName,"lowercase") + "/" $! $ if onDemandGenerate  $    then adminGenerate = 0  $    else adminGenerate = 1  $ endif  $!A $!(search for latest version of OpenSSL in default WASD location)  $ if OpenSSLdir .eqs. "" $ then $    sslDirLoop:; $       tmpDir = f$search("HT_ROOT:[SRC]OPENSSL-*_*_*.DIR") 3 $       if tmpDir .eqs. "" then goto end_sslDirLoop / $       sslDirPos = f$locate("]OPENSSL",tmpDir) < $       OpenSSLdir = f$extract(0,sslDirPos,tmpDir) + "." + -G                      f$extract(sslDirPos+1,999,tmpDir) - ".DIR;1" + "]"  $       goto sslDirLoop  $    end_sslDirLoop: $! $    if OpenSSLdir .eqs. "" 	 $    then P $       call certRequestFailed "Cannot locate WASD OpenSSL directory structure." $       exit
 $    endif $!? $    parentDir = f$extract(0,f$length(openSSLdir)-1,openSSLdir) & $    defaultDir = parentDir + ".WASD]"4 $    defaultConfig = parentDir + ".WASD]DEFAULT.CNF"+ $    PEMcertDir = parentDir + ".WASD.CERT]" ; $    opensslEXE = "$" + parentDir + ".AXP.EXE.APPS]OPENSSL"  $! $ endif  $!  $!(add the CA utility parameter)  $ opensslCA = opensslEXE + " CA"$ $ opensslX509 = opensslEXE + " X509" $! $ if scratchDir .eqs. "" $ then' $    if f$trnlnm("HT_SCRATCH") .eqs. "" 0 $       then scratchDir = "HT_ROOT:[LOG.SERVER]"' $       else scratchDir = "HT_SCRATCH:" 
 $    endif $ endif  $!H $!(set up the file names at top-level, so accessable to all subroutines)? $ CSRfileName = scratchDir + procName + "_REQ." + WWW_UNIQUE_ID D $ CAoutputFileName = scratchDir + procName + "_CAO." + WWW_UNIQUE_ID@ $ randFileName = scratchDir + procName + "_RND." + WWW_UNIQUE_ID@ $ certFileName = scratchDir + procName + "_DER." + WWW_UNIQUE_ID< $ PEMfileName = PEMcertDir + procName + "." + WWW_UNIQUE_ID  $!O $!-----------------------------------------------------------------------------  $!6 $!(end of configuration, begin main execution routine)& $ if WWW_PATH_INFO .eqs. pathInfoAdmin $ then $!   (site admin phase)  $    clientPhase = 0  $    if WWW_REMOTE_USER .eqs. ""	 $    then   $       call certRequestFailed -O              "Access to ""''pathInfoAdmin'"" must be authorization controlled!"  $       exit
 $    endif& $    if WWW_REQUEST_METHOD .eqs. "GET"	 $    then ! $       call adminCertRequestForm 	 $    else  $!      (POSTed form)  $       call adminSaveCSR " $       if .not. $status then exit( $       durationDays = WWW_FORM_DURATION@ $       if f$integer(durationDays) .le 0 then durationDays = 365H $       if f$type(CApassphrase) .eqs. "" then delete/symbol CApassphrase, $       CApassphrase = WWW_FORM_CAPASSPHRASE $       call generateCert " $       if .not. $status then exit $       call adminReturnCert" $       if .not. $status then exit
 $    endif $ else $!   (client phase)  $    clientPhase = 1@ $    if f$length(WWW_PATH_INFO) - 1 .eq. f$length(WWW_UNIQUE_ID)	 $    then D $       call userReturnAdminCert "''f$extract(1,999,WWW_PATH_INFO)'"	 $    else ) $       if WWW_REQUEST_METHOD .eqs. "GET"  $       then# $          call userCertRequestForm % $          if .not. $status then exit  $       else $!         (POSTed form) $          if onDemandGenerate $          then  $             call userBuildCSR ( $             if .not. $status then exit $             call generateCert ( $             if .not. $status then exit! $             call userReturnCert ( $             if .not. $status then exit $          else ) $             if CSRemailAddress .eqs. ""  $             thenD $                call certRequestFailed "CSR email address not set."# $                exit NORMAL_STATUS  $             endif  $             call userBuildCSR ( $             if .not. $status then exit $             call userEmailCSR ( $             if .not. $status then exit $          endif
 $       endif 
 $    endif $ endif  $ call cleanup $! $!(exit from procedure)  $ exit $!O $!-----------------------------------------------------------------------------  $!- $!(build Certificate Signing Request in file)  $ userBuildCSR: subroutine
 $ set noon $!? $!(use CGIutl to extract the POSTed form body into DCL symbols) . $ CGIutl /urldecode /symbol /prefix="WWW_FORM"& $ if debug then show symbol WWW_FORM_* $!! $! (fail if not Netscape browser) $ $ if f$type(WWW_FORM_SPKAC) .eqs. "" $ thenI $    call certRequestFailed "No Key provided (SPKAC). Netscape required."  $    exit ERROR_STATUS $ endif  $!+ $!(check that we've got all the essentials)  $ ok = 15 $ if f$type(WWW_FORM_COMMONNAME) .eqs. "" then ok = 0 7 $ if f$type(WWW_FORM_EMAILADDRESS) .eqs. "" then ok = 0 ; $ if f$type(WWW_FORM_ORGANIZATIONNAME) .eqs. "" then ok = 0 A $ if f$type(WWW_FORM_ORGANIZATIONALUNITNAME) .eqs. "" then ok = 0 7 $ if f$type(WWW_FORM_LOCALITYNAME) .eqs. "" then ok = 0 > $ if f$type(WWW_FORM_STATEORPROVINCENAME) .eqs. "" then ok = 06 $ if f$type(WWW_FORM_COUNTRYNAME) .eqs. "" then ok = 0
 $ if .not. ok  $ thenL $    call certRequestFailed "All the required information is not available." $    exit ERROR_STATUS $ endif  $!+ $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl:& $ create 'CSRfileName' /fdl=SYS$INPUT: FILE ORGANIZATION sequential  RECORD  CARRIAGE_CONTROL carriage_return FORMAT stream_LF$ $ open /append CSRfile 'CSRfileName'= $ WWW_FORM_COMMONNAME = "commonName = " + WWW_FORM_COMMONNAME + $ write /symbol CSRfile WWW_FORM_COMMONNAME C $ WWW_FORM_EMAILADDRESS = "emailAddress = " + WWW_FORM_EMAILADDRESS - $ write /symbol CSRfile WWW_FORM_EMAILADDRESS O $ WWW_FORM_ORGANIZATIONNAME = "organizationName = " + WWW_FORM_ORGANIZATIONNAME 1 $ write /symbol CSRfile WWW_FORM_ORGANIZATIONNAME a $ WWW_FORM_ORGANIZATIONALUNITNAME = "organizationalUnitName = " + WWW_FORM_ORGANIZATIONALUNITNAME 7 $ write /symbol CSRfile WWW_FORM_ORGANIZATIONALUNITNAME C $ WWW_FORM_LOCALITYNAME = "localityName = " + WWW_FORM_LOCALITYNAME - $ write /symbol CSRfile WWW_FORM_LOCALITYNAME X $ WWW_FORM_STATEORPROVINCENAME = "stateOrProvinceName = " + WWW_FORM_STATEORPROVINCENAME4 $ write /symbol CSRfile WWW_FORM_STATEORPROVINCENAME@ $ WWW_FORM_COUNTRYNAME = "countryName = " + WWW_FORM_COUNTRYNAME, $ write /symbol CSRfile WWW_FORM_COUNTRYNAMEK $!(the SPKAC has embedded newlines, it need transforming into ASN.1 syntax)  $ write CSRfile "SPKAC = \"  $ SPKACloop:( $    lfpos = f$locate(lf,WWW_FORM_SPKAC)- $    if lfpos+1 .ge. f$length(WWW_FORM_SPKAC) 	 $    then N $!      (must be the last and non-newline delimited extract, no continuation!)0 $       line = f$extract(0,lfpos,WWW_FORM_SPKAC) $       WWW_FORM_SPKAC = "" 	 $    else K $!      (append a continuation character to this newline-delimited extract) 6 $       line = f$extract(0,lfpos,WWW_FORM_SPKAC) + "\"> $       WWW_FORM_SPKAC = f$extract(lfpos+1,999,WWW_FORM_SPKAC)
 $    endif $    write /symbol CSRfile line 3 $    if WWW_FORM_SPKAC .nes. "" then goto SPKACloop  $ SPKACloopEnd:  $ close CSRfile & $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $!# $ if f$search(CSRfileName) .eqs. ""  $ then4 $    call certRequestFailed "Error saving CSR file." $    exit ERROR_STATUS $ endif & $ if f$file(CSRfileName,"EOF") .eqs. 0 $ then8 $    call certRequestFailed "Error populating CSR file."	 $    exit  $ endif  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ adminSaveCSR: subroutine
 $ set noon $!H $!(use CGIutl to extract the POSTed form body into DCL symbols and file)7 $ CGIutl /quiet /urldecode /symbols /prefix="WWW_FORM"  
 $ if debug $ then $    show sym www_form_*, $    write sys$output f$length(WWW_FORM_CSR) $ endif  $!" $ if f$type(WWW_FORM_CSR) .eqs. "" $ then0 $    call certRequestFailed "CSR not available."	 $    exit  $ endif $ $ if f$length(WWW_FORM_CSR) .lt. 512 $ then1 $    call certRequestFailed "CSR looks doubtful." 	 $    exit  $ endif  $!+ $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl:& $ create 'CSRfileName' /fdl=SYS$INPUT: FILE ORGANIZATION sequential  RECORD  CARRIAGE_CONTROL carriage_return FORMAT stream_LF$ $ open /append CSRfile 'CSRfileName'$ $ write /symbol CSRfile WWW_FORM_CSR $ close CSRfile & $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $!# $ if f$search(CSRfileName) .eqs. ""  $ then4 $    call certRequestFailed "Error saving CSR file." $    exit ERROR_STATUS $ endif & $ if f$file(CSRfileName,"EOF") .eqs. 0 $ then8 $    call certRequestFailed "Error populating CSR file." $    exit ERROR_STATUS $ endif  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ generateCert: subroutine
 $ set noon $! $ if CApassphrase .eqs. "" $ then: $    call certRequestFailed "CA passphrase not specified." $    exit ERROR_STATUS $ endif  $!= $ if f$type(defaultDir) .nes "" then set default 'defaultDir' + $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl: $ directory *.*  $ if .not. $status $ then6 $    call certRequestFailed "Directory setup problem." $    exit ERROR_STATUS $ endif  $!* $!(initialize the random number seed file)' $ create 'randFileName' /fdl=SYS$INPUT:  FILE ORGANIZATION sequential  RECORD  CARRIAGE_CONTROL carriage_return FORMAT stream_LF& $ open /append randFile 'randFileName' $ show system /output=randFile $ close randFile& $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $!$ $ if f$search(randFileName) .eqs. "" $ then> $    call certRequestFailed "Error creating random seed file." $    exit ERROR_STATUS $ endif ' $ if f$file(randFileName,"EOF") .eqs. 0  $ then@ $    call certRequestFailed "Error populating random seed file." $    exit ERROR_STATUS $ endif  $!1 $!(execute the CA utility, capturing it's output) - $ define /nolog sys$output 'CAoutputFileName' , $ define /nolog sys$error 'CAoutputFileName' $ RANDFILE = randFileName A $ opensslCA -batch -config 'defaultConfig' -days 'durationDays' - K             -key "''CApassphrase'" -spkac 'CSRfileName' -out 'certFileName' & $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $!$ $ if f$search(certFileName) .eqs. "" $ then; $    call certRequestFailed "Error when CA processing CSR."  $    exit ERROR_STATUS $ endif ' $ if f$file(certFileName,"EOF") .eqs. 0  $ then; $    call certRequestFailed "Error when CA processing CSR."  $    exit ERROR_STATUS $ endif  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ userReturnCert: subroutine
 $ set noon $!D $!(on-demand, return the certificate directly to the user's browser)I $ CGIutl /response /content="application/x-x509-user-cert" 'certFileName'  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $!! $ userReturnAdminCert: subroutine 
 $ set noon $!1 $ PEMfileName = PEMcertDir + procName + "." + P1  + $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl: $ directory 'PEMfileName'  $ dirStatus = $status & $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $ if .not. dirStatus $ then4 $    call certRequestFailed "Certificate not found." $    exit ERROR_STATUS $ endif  $!+ $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl:L $ OpenSSLX509 -inform PEM -in 'PEMfileName' -outform DER -out 'certFileName'& $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $!I $ CGIutl /response /content="application/x-x509-user-cert" 'certFileName'  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ adminReturnCert: subroutine 
 $ set noon $!( $ define /nolog sys$output 'PEMfileName'' $ define /nolog sys$error 'PEMfileName'  $ type sys$inputG This certificate can be obtained in binary at any time by accessing the  following URL:  A $ say "        " + WWW_REQUEST_SCHEME + "//" + WWW_SERVER_NAME +- =       WWW_SCRIPT_NAME + "/" +  F$EDIT(WWW_UNIQUE_ID,"upcase")  $ say ""2 $ OpenSSLX509 -inform DER -in 'certFileName' -text& $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError'6 $ CGIutl /response /content="text/plain" 'PEMfileName' $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ userEmailCSR: subroutine
 $ set noon $!; $!(email the CSR to the site administrator's email address) + $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl:+ $ mail 'CSRfileName' "''CSRemailAddress'" - 3        /subject="CSR from ''WWW_FORM_EMAILADDRESS'"  $ mailStatus = $STATUS& $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $ if mailStatus  $ then $    type sys$input  Content-Type: text/html    <HTML> <HEAD>< <TITLE>Certificate Signing Request Successfully Sent</TITLE> </HEAD>  <BODY>> <FONT SIZE=+1><B><U>Certificate Signing Request</U></B></FONT>E <P>Certificate Signing Request was sent successfully!&nbsp; Thankyou. - $    if f$type(WWW_SERVER_SIGNATURE) .nes. "" 	 $    then 9 $       say "<P><HR WIDTH=85% ALIGN=left SIZE=2 NOSHADE>"   $       say WWW_SERVER_SIGNATURE
 $    endif $    type sys$input  </BODY>  </HTML>  $ elseg $    call certRequestFailed "A problem occured when sending.<BR>Please contact the site administrator."  $ endif  $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ cleanup: subroutine 
 $ set noon $! $exit NORMAL_STATUS + $ if .not. debug then define sys$output nl: * $ if .not. debug then define sys$error nl:3 $ delete /noconfirm 'scratchDir'*.'WWW_UNIQUE_ID';* & $ define /nolog sys$output 'sysOutput'$ $ define /nolog sys$error 'sysError' $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $! $ certRequestFailed: subroutine 
 $ set noon $! $ type sys$input Status: 403  Content-Type: text/html    <HTML> <HEAD>1 <TITLE>Certificate Signing Request Failed</TITLE>  </HEAD>  <BODY>E <FONT SIZE=+1><B><U>Certificate Signing Request Failed</U></B></FONT>  <P>  $ say P1& $ if f$type(CAoutputFileName) .nes. "" $ then+ $    if f$search(CAoutputFileName) .nes. "" 	 $    then  $       say "<PRE>" ! $       CGIutl 'CAoutputFileName'  $       say "</PRE>"
 $    endif $ endif  $! $ if clientPhase $ then $    type sys$input  <P><B>Request Details:</B> <PRE> I $ if f$type(WWW_FORM_COMMONNAME) .nes. "" then saysym WWW_FORM_COMMONNAME M $ if f$type(WWW_FORM_EMAILADDRESS) .nes. "" then saysym WWW_FORM_EMAILADDRESS U $ if f$type(WWW_FORM_ORGANIZATIONNAME) .nes. "" then saysym WWW_FORM_ORGANIZATIONNAME a $ if f$type(WWW_FORM_ORGANIZATIONALUNITNAME) .nes. "" then saysym WWW_FORM_ORGANIZATIONALUNITNAME M $ if f$type(WWW_FORM_LOCALITYNAME) .nes. "" then saysym WWW_FORM_LOCALITYNAME [ $ if f$type(WWW_FORM_STATEORPROVINCENAME) .nes. "" then saysym WWW_FORM_STATEORPROVINCENAME K $ if f$type(WWW_FORM_COUNTRYNAME) .nes. "" then saysym WWW_FORM_COUNTRYNAME  $    say "</PRE>"  $ endif  $!* $ if f$type(WWW_SERVER_SIGNATURE) .nes. "" $ then6 $    say "<P><HR WIDTH=85% ALIGN=left SIZE=2 NOSHADE>" $    say WWW_SERVER_SIGNATURE  $ endif  $ type sys$input </BODY>  </HTML>  $! $ call cleanup $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $!! $ userCertRequestForm: subroutine 
 $ set noon $! $ type sys$input Content-Type: text/html    <HTML> <HEAD>1 <TITLE>Client Certificate Signing Request</TITLE>  </HEAD>  <BODY>E <FONT SIZE=+1><B><U>Client Certificate Signing Request</U></B></FONT>   = $ say "<FORM METHOD=POST ACTION=""" + WWW_SCRIPT_NAME + """>"  $ type sys$input, <TABLE CELLPADDING=0 CELLSPACING=3 BORDER=0> <TR><TD>Common Name:</TD><TD> O <INPUT TYPE="TEXT" NAME="commonName" VALUE="how you identify yourself" SIZE=64> 
 </TD></TR> <TR><TD>Email Address:</TD><TD> E <INPUT TYPE="TEXT" NAME="emailAddress" VALUE="name@host.dom" SIZE=40> 
 </TD></TR> <TR><TD>Organization:</TD><TD>N <INPUT TYPE="TEXT" NAME="organizationName" VALUE="WASD HTTPd CA Cert" SIZE=40>
 </TD></TR>% <TR><TD>Organizational Unit:</TD><TD> \ <INPUT TYPE="TEXT" NAME="organizationalUnitName" VALUE="OpenSSL 0.9.6 Testing Only" SIZE=40>
 </TD></TR>! <TR><TD>Locality (City):</TD><TD> 8 <INPUT TYPE="TEXT" NAME="localityName" VALUE="Adelaide">
 </TD></TR># <TR><TD>State or Province:</TD><TD> 9 <INPUT TYPE="TEXT" NAME="stateOrProvinceName" VALUE="SA"> 
 </TD></TR> <TR><TD>Country:</TD><TD> : <INPUT TYPE="TEXT" NAME="countryName" VALUE="AU" SIZE="2">
 </TD></TR> </TABLE>M <!-- keygen is Netscape specific and will be ignored in internet explorer --> 3 <KEYGEN NAME="SPKAC" CHALLENGE="challengePassword"> * <INPUT TYPE=submit VALUE="Submit Request"> </FORM>  $ if onDemandGenerate  $ then $    type sys$input O <P> Submitting this request will activate a service to automatically generate a L client certificate.&nbsp;  Please be patient, it may take some time (perhapsN tens of seconds).&nbsp;  When complete you be notified of any problems.&nbsp; K If successful the certificate will be returned directly to your browser for  installation in it's database. $ else $    type sys$input M <P> Submitting this request will generate a Certificate Signing Request (CSR) M which will then be forwarded to the site administrator.&nbsp; The certificate N will then at some time in the immediate future be signed at the adminstrator'sN discretion.&nbsp; You will be notified by email using the address specified by	 the form.  $ endif * $ if f$type(WWW_SERVER_SIGNATURE) .nes. "" $ then6 $    say "<P><HR WIDTH=85% ALIGN=left SIZE=2 NOSHADE>" $    say WWW_SERVER_SIGNATURE  $ endif  $    type sys$input  </BODY>  </HTML>  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!-----------------------------------------------------------------------------  $!" $ adminCertRequestForm: subroutine
 $ set noon $! $ type sys$input Content-Type: text/html    <HTML> <HEAD>0 <TITLE>Admin Generate Client Certificate</TITLE> </HEAD>  <BODY>* <H3>Admin Generate Client Certificate</H3>= $ say "<FORM METHOD=POST ACTION=""" + WWW_REQUEST_URI + """>"  $ type sys$input5 <P>Cut and paste CSR from source into this text area: < <TEXTAREA NAME=CSR ROWS=20 COLS=80 WRAP=none></TEXTAREA><BR> <NOBR>	 Duration: L <INPUT TYPE=duration NAME=duration SIZE=4 VALUE=365> <I>days</I>&nbsp;&nbsp; CA passphrase:; <INPUT TYPE=password NAME=capassphrase SIZE=20>&nbsp;&nbsp; & <INPUT TYPE=submit VALUE="Submit CSR">  <INPUT TYPE=reset VALUE="reset"> </NOBR>  </FORM> * $ if f$type(WWW_SERVER_SIGNATURE) .nes. "" $ then6 $    say "<P><HR WIDTH=85% ALIGN=left SIZE=2 NOSHADE>" $    say WWW_SERVER_SIGNATURE  $ endif  </BODY>  </HTML>  $! $ exit NORMAL_STATUS $ endsubroutine  $!O $!----------------------------------------------------------------------------- 