$!-----------------------------------------------------------------------------
$! CREATE_CA_CERT.COM
$!
$! Create our own "Certificate Authority" certificate!
$! This procedure is very "quick-and-dirty", use with that in mind!
$!
$! P1 optionally specifies the configuration file (defaults to DEFAULT.CNF)
$!
$! 07-APR-2001  MGD  OPENSSL-0_9_6A
$! 25-SEP-2000  MGD  OPENSSL-0_9_6
$! 05-MAR-2000  MGD  OPENSSL-0_9_5
$! 17-AUG-1999  MGD  refinement (OPENSSL-0_9_4)
$! 04-JUN-1999  MGD  OPENSSL-0_9_3 (adapted from earlier procedures)
$!-----------------------------------------------------------------------------
$!
$ days = 1825   !(5 * 365 == valid for five years!)
$!
$ certDir = "[.CERT]"
$ workDir = "[.CERT.WORK]"
$!
$ say = "write sys$output"
$ arch = "AXP"
$ if f$getsyi("cpu") .lt. 128 then arch = "VAX"
$ openSSL = "$HT_ROOT:[SRC.OPENSSL-0_9_6.''arch'.EXE.APPS]OPENSSL"
$!
$ configFileName = f$edit(P1,"lowercase")
$ if configFileName .eqs. "" then configFileName = "default.cnf"
$ configFileName = configFileName - ".cnf" + ".cnf"
$!
$ on error then goto serverError
$ procedure = f$environment("procedure") - "000000."
$ newDefault = f$parse(procedure,,,"device") + f$parse(procedure,,,"directory")
$ prevDefault = f$environment("default")
$ set default 'newDefault'
$!
$ @CREATE_SUPPORT_FILES
$!
$ say ""
$ say f$fao("!80*-")
$ say "CREATE NEW CA CERTIFICATE"
$ say ""
$ say "Remember the PEM pass phrase (password) - it's case sensitive!"
$ say "It will be needed whenever a server certificate is generated."
$ say f$fao("!80*-")
$ say ""
$ define /user sys$input sys$command
$!(^Y during password entry leaves the terminal kaput!)
$ set nocontrol=y
$ openSSL req -days 'DAYS' -verify -new -x509 -config 'configFileName' -
              -outform PEM -out 'workDir'TMPCERT.PEM -
              -keyout 'workDir'TMPKEY.PEM
$ set control=y
$!
$!(append key to certificate as final file)
$ copy 'workDir'TMPCERT.PEM,'workDir'TMPKEY.PEM 'certDir'_CACERT.PEM
$ define /user sys$output nl:
$ define /user sys$error nl:
$!
$ say ""
$ say f$fao("!80*-")
$ say "CREATING DER (.CRT) VERSION"
$ say f$fao("!80*-")
$ say ""
$ define /user sys$input sys$command
$ OpenSSL x509 -inform PEM -serial -issuer -outform DER -
               -in 'certDir'_CACERT.PEM -out 'certDir'_CACERT.CRT
$!
$ say ""
$ say f$fao("!80*-")
$ say "FINISHED"
$ say ""
$ say "New CA certificate:"
$ say "PEM = " + f$search("''certDir'_CACERT.PEM")
$ say "CRT = " + f$search("''certDir'_CACERT.CRT")
$ say f$fao("!80*-")
$!
$ goto caCleanup
$!
$ serverError:
$ say ""
$ say f$fao("!80**")
$ say "E R R O R"
$ say f$fao("!80**")
$!
$ caCleanup:
$ define /user sys$output nl:
$ define /user sys$error nl:
$ delete 'workDir'*.PEM;*
$ define /user sys$output nl:
$ define /user sys$error nl:
$ set prot=w 'certDir'_cacert.pem,'certDir'_cacert.crt
$ if f$type(RANDFILE) .nes. "" then delete/symbol/global RANDFILE
$!
$ say ""
$ set default 'prevDefault'
$!
$!-----------------------------------------------------------------------------
