$!-----------------------------------------------------------------------------
$! CREATE_SERVER_CERT.COM
$!
$! Create our own server certificate!
$! This procedure is very "quick-and-dirty", use with that in mind!
$!
$! P1 must specify the server certificate file name
$! P2 optionally specified the configuration file (defaults to DEFAULT.CNF)
$!
$! 20-MAY-2001  MGD  optional non-embedded private key password
$! 07-APR-2001  MGD  OPENSSL-0_9_6A
$! 25-SEP-2000  MGD  OPENSSL-0_9_6 
$! 05-MAR-2000  MGD  OPENSSL-0_9_5 
$! 17-AUG-1999  MGD  refinement (OPENSSL-0_9_4)
$! 04-JUN-1999  MGD  OPENSSL-0_9_3 (adapted from earlier procedures)
$!-----------------------------------------------------------------------------
$!
$ days = 1825   !(5 * 365 == valid for five years!)
$!
$ certDir = "[.CERT]"
$ workDir = "[.CERT.WORK]"
$!
$ say = "write sys$output"
$ arch = "AXP"
$ if f$getsyi("cpu") .lt. 128 then arch = "VAX"
$ openSSL = "$HT_ROOT:[SRC.OPENSSL-0_9_6.''arch'.EXE.APPS]OPENSSL"
$!
$ if P1 .eqs. ""
$ then
$    say "P1 must be the name of the certificate file (e.g. ""MINE"")."
$    exit
$ endif
$ certFileName = f$edit(P1,"lowercase") - ".pem" + ".pem"
$!
$ configFileName = f$edit(P2,"lowercase")
$ if configFileName .eqs. "" then configFileName = "default.cnf"
$ configFileName = configFileName - ".cnf" + ".cnf"
$!
$ on error then goto serverError
$ procedure = f$environment("procedure") - "000000."
$ newDefault = f$parse(procedure,,,"device") + f$parse(procedure,,,"directory")
$ prevDefault = f$environment("default")
$ set default 'newDefault'
$!
$ @CREATE_SUPPORT_FILES
$!
$ say ""
$ say f$fao("!80*-")
$ say "GENERATE CERTIFICATE REQUEST"
$ say ""
$ say "When prompted for: ""Enter PEM pass phrase:"""
$ say "                   ... use ""12345"", or your own *secret* password"
$ say "                   ""common name"" enter the server's full host name."
$ say f$fao("!80*-")
$ say ""
$ define /user sys$input sys$command
$!(^Y during password entry leaves the terminal kaput!)
$ set nocontrol=y
$ openSSL req -newkey rsa:512 -verify -new -config 'configFileName' -
              -outform PEM -out 'workDir'TMPREQ.PEM -
              -keyout 'workDir'TMPKEY1.PEM
$ set control=y
$!
$ say ""
$ say f$fao("!80*-")
$ say "SIGN CERTIFICATE"
$ say ""
$ say "When prompted for: ""Enter PEM pass phrase:"" supply the CA password."
$ say "(the default WASD CA PEM pass phrase is ""testing"" - case sensitive)"
$ say f$fao("!80*-")
$ say ""
$ define /user sys$input sys$command
$ set nocontrol=y
$ openSSL ca -days 'DAYS' -policy policy_anything -config 'configFileName' -
             -outdir 'workDir' -out 'workDir'TMPCERT.PEM -
             -infiles 'workDir'TMPREQ.PEM
$ set control=y
$!
$ say ""
$ say f$fao("!80*-")
$ say "CHECK FOR SUCCESSFUL SIGNING"
$ say ""
$ say "Indication of success: ""Data Base Updated"""
$ say "                error: ""The matching entry"" or obvious error message"
$ say f$fao("!80*-")
$ say ""
$ signingLoop:
$    say ""
$    read sys$command line -
          /error=serverError /end=serverCleanup -
          /prompt="Successful? [y/n]: "
$    if line .eqs. "" then goto signingLoop
$ if .not. line then goto serverCleanup
$!
$ say ""
$ say f$fao("!80*-")
$ say "PROVIDE EMBEDDED PRIVATE KEY PASSWORD"
$ say ""
$ say "Private key password can be embedded with the private key (covenient)"
$ say "or provided manually at each server startup (secure but less convenient)"
$ say f$fao("!80*-")
$ say ""
$ passwordLoop:
$    say ""
$    read sys$command line -
          /error=serverError /end=serverCleanup -
          /prompt="Embed private key password? [y/n]: "
$    if line .eqs. "" then goto passwordLoop
$!
$ if line
$ then
$!
$    say ""
$    say "EMBED PEM PASS PHRASE"
$    say ""
$    say "When prompted for: ""Enter PEM pass phrase:"""
$    say "                   ... use ""12345"", or your own *secret* password"
$    say f$fao("!80*-")
$    say ""
$    define /user sys$input sys$command
$    set nocontrol=y
$    openSSl rsa -in 'workDir'TMPKEY1.PEM -out 'workDir'TMPKEY2.PEM 
$    rename 'workDir'TMPKEY2.PEM 'workDir'TMPKEY1.PEM;0
$    set control=y
$!
$ endif
$!
$!(append key to certificate as final file)
$ copy 'workDir'TMPCERT.PEM,'workDir'TMPKEY1.PEM 'certDir''certFileName'
$ define /user sys$output nl:
$ define /user sys$error nl:
$ set prot=w 'certDir''certFileName'
$!
$ say ""
$ say f$fao("!80*-")
$ say "FINISHED"
$ say ""
$ say "New server certificate is " + f$search("''certDir'''certFileName'")
$ say f$fao("!80*-")
$!
$ goto serverCleanup
$!
$ serverError:
$ say ""
$ say f$fao("!80**")
$ say "E R R O R"
$ say f$fao("!80**")
$!
$ serverCleanup:
$ define /user sys$output nl:
$ define /user sys$error nl:
$ delete 'workDir'*.PEM;*
$ define /user sys$output nl:
$ define /user sys$error nl:
$ purge /nolog /keep=1 'workDir'SERIAL.*,'workDir'INDEX.*,'workDir'RAND.*
$ if f$type(RANDFILE) .nes. "" then delete/symbol/global RANDFILE
$!
$ say ""
$ set default 'prevDefault'
$!
$!-----------------------------------------------------------------------------
