!++
!     Builds rdesktop.exe with OpenSSL
!--

.IFDEF DEBUG
DBG = /DEBUG
DBGOPT = /NOOPTIMIZE/DEBUG
.ELSE
DBG = /NODEBUG
DBGOPT = /OPTIMIZE/NODEBUG
.ENDIF

.IFDEF LIST
LST = /LIST
.ELSE
LST = /NOLIST
.ENDIF

.IFDEF DIAG
DIA = /DIAGNOSTICS
.ELSE
DIA = /NODIAGNOSTICS
.ENDIF

.IFDEF PCA
PCAOPT = /DEBUG
.ENDIF

CFLAGS =/nowarn/pref=all/define=(WITH_OPENSSL,KEYMAP_PATH="""/etc/keymaps/""")/include=decw$include: 


!++
!     Missing sources catch-all
!--

.DEFAULT
   ! No source found for $(MMS$TARGET)
   ! - Attempting to continue



!++
!   Complete application - default build item
!--

COMPLETE_APPLICATION depends_on -
     RDESKTOP.EXE
        CONTINUE


!++
!   C
!--

RDESKTOP.OLB(BITMAP=BITMAP.OBJ) depends_on -
      BITMAP.C -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=BITMAP.OBJ BITMAP.C
       LIBRARY/REPLACE RDESKTOP.OLB BITMAP.OBJ
       DELETE BITMAP.OBJ;*

RDESKTOP.OLB(CACHE=CACHE.OBJ) depends_on -
      CACHE.C -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=CACHE.OBJ CACHE.C
       LIBRARY/REPLACE RDESKTOP.OLB CACHE.OBJ
       DELETE CACHE.OBJ;*

RDESKTOP.OLB(EWMHINTS=EWMHINTS.OBJ) depends_on -
      EWMHINTS.C -
     ,RDESKTOP.H -
     ,X11:XLIB.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=EWMHINTS.OBJ EWMHINTS.C
       LIBRARY/REPLACE RDESKTOP.OLB EWMHINTS.OBJ
       DELETE EWMHINTS.OBJ;*

RDESKTOP.OLB(VMS_GETPASS=VMS_GETPASS.OBJ) depends_on -
      VMS_GETPASS.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(DESCRIP=DESCRIP.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDDEF=STDDEF.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(UNISTD=UNISTD.H) -
     ,SYS$LIBRARY:SYS$STARLET_C.TLB(IODEF=IODEF.H) -
     ,SYS$LIBRARY:SYS$STARLET_C.TLB(STARLET=STARLET.H) -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=VMS_GETPASS.OBJ VMS_GETPASS.C
       LIBRARY/REPLACE RDESKTOP.OLB VMS_GETPASS.OBJ
       DELETE VMS_GETPASS.OBJ;*

RDESKTOP.OLB(VMS_IMUTIL=VMS_IMUTIL.OBJ) depends_on -
      VMS_IMUTIL.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,X11:XLIBINT.H -
     ,X11:XUTIL.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=VMS_IMUTIL.OBJ VMS_IMUTIL.C
       LIBRARY/REPLACE RDESKTOP.OLB VMS_IMUTIL.OBJ
       DELETE VMS_IMUTIL.OBJ;*

RDESKTOP.OLB(ISO=ISO.OBJ) depends_on -
      ISO.C -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=ISO.OBJ ISO.C
       LIBRARY/REPLACE RDESKTOP.OLB ISO.OBJ
       DELETE ISO.OBJ;*

RDESKTOP.OLB(LICENCE=LICENCE.OBJ) depends_on -
      LICENCE.C -
     ,OPENSSL:RC4.H -
     ,RDESKTOP.H -
     ,OPENSSL:OPENSSLCONF.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=LICENCE.OBJ LICENCE.C
       LIBRARY/REPLACE RDESKTOP.OLB LICENCE.OBJ
       DELETE LICENCE.OBJ;*

RDESKTOP.OLB(MCS=MCS.OBJ) depends_on -
      MCS.C -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=MCS.OBJ MCS.C
       LIBRARY/REPLACE RDESKTOP.OLB MCS.OBJ
       DELETE MCS.OBJ;*

RDESKTOP.OLB(ORDERS=ORDERS.OBJ) depends_on -
      ORDERS.C -
     ,ORDERS.H -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=ORDERS.OBJ ORDERS.C
       LIBRARY/REPLACE RDESKTOP.OLB ORDERS.OBJ
       DELETE ORDERS.OBJ;*

RDESKTOP.OLB(VMS_RDESKTOP=VMS_RDESKTOP.OBJ) depends_on -
      VMS_RDESKTOP.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(FCNTL=FCNTL.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(PWD=PWD.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDARG=STDARG.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(UNISTD=UNISTD.H) -
     ,OPENSSL:MD5.H -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=VMS_RDESKTOP.OBJ VMS_RDESKTOP.C
       LIBRARY/REPLACE RDESKTOP.OLB VMS_RDESKTOP.OBJ
       DELETE VMS_RDESKTOP.OBJ;*

RDESKTOP.OLB(RDP=RDP.OBJ) depends_on -
      RDP.C -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=RDP.OBJ RDP.C
       LIBRARY/REPLACE RDESKTOP.OLB RDP.OBJ
       DELETE RDP.OBJ;*

RDESKTOP.OLB(SECURE=SECURE.OBJ) depends_on -
      SECURE.C -
     ,OPENSSL:BN.H -
     ,OPENSSL:MD5.H -
     ,OPENSSL:RC4.H -
     ,RDESKTOP.H -
     ,OPENSSL:SHA.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,OPENSSL:OPENSSLCONF.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=SECURE.OBJ SECURE.C
       LIBRARY/REPLACE RDESKTOP.OLB SECURE.OBJ
       DELETE SECURE.OBJ;*

RDESKTOP.OLB(TCP=TCP.OBJ) depends_on -
      TCP.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(NETDB=NETDB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(UNISTD=UNISTD.H) -
     ,RDESKTOP.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=TCP.OBJ TCP.C
       LIBRARY/REPLACE RDESKTOP.OLB TCP.OBJ
       DELETE TCP.OBJ;*

RDESKTOP.OLB(XKEYMAP=XKEYMAP.OBJ) depends_on -
      XKEYMAP.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(CTYPE=CTYPE.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(LIMITS=LIMITS.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,X11:KEYSYMDEF.H -
     ,RDESKTOP.H -
     ,SCANCODES.H -
     ,X11:XLIB.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=XKEYMAP.OBJ XKEYMAP.C
       LIBRARY/REPLACE RDESKTOP.OLB XKEYMAP.OBJ
       DELETE XKEYMAP.OBJ;*

RDESKTOP.OLB(VMS_XWIN=VMS_XWIN.OBJ) depends_on -
      VMS_XWIN.C -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(ERRNO=ERRNO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(TIME=TIME.H) -
     ,RDESKTOP.H -
     ,X11:XLIB.H -
     ,X11:XUTIL.H -
     ,CONSTANTS.H -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDIO=STDIO.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STDLIB=STDLIB.H) -
     ,SYS$LIBRARY:DECC$RTLDEF.TLB(STRING=STRING.H) -
     ,PARSE.H -
     ,PROTO.H -
     ,TYPES.H -
     !
       $(CC) $(CFLAGS)  $(LST) $(DBGOPT) $(DIA) /OBJ=VMS_XWIN.OBJ VMS_XWIN.C
       LIBRARY/REPLACE RDESKTOP.OLB VMS_XWIN.OBJ
       DELETE VMS_XWIN.OBJ;*


!++
!   Links
!--

RDESKTOP.EXE depends_on -
      RDESKTOP.OLB(BITMAP=BITMAP.OBJ) -
     ,RDESKTOP.OLB(CACHE=CACHE.OBJ) -
     ,RDESKTOP.OLB(EWMHINTS=EWMHINTS.OBJ) -
     ,RDESKTOP.OLB(VMS_GETPASS=VMS_GETPASS.OBJ) -
     ,RDESKTOP.OLB(VMS_IMUTIL=VMS_IMUTIL.OBJ) -
     ,RDESKTOP.OLB(ISO=ISO.OBJ) -
     ,RDESKTOP.OLB(LICENCE=LICENCE.OBJ) -
     ,RDESKTOP.OLB(MCS=MCS.OBJ) -
     ,RDESKTOP.OLB(ORDERS=ORDERS.OBJ) -
     ,RDESKTOP.OLB(VMS_RDESKTOP=VMS_RDESKTOP.OBJ) -
     ,RDESKTOP.OLB(RDP=RDP.OBJ) -
     ,RDESKTOP.OLB(SECURE=SECURE.OBJ) -
     ,RDESKTOP.OLB(TCP=TCP.OBJ) -
     ,RDESKTOP.OLB(XKEYMAP=XKEYMAP.OBJ) -
     ,RDESKTOP.OLB(VMS_XWIN=VMS_XWIN.OBJ) -
     !
       LINK /CROSS/MAP $(DBG) $(PCAOPT) /EXE=RDESKTOP.EXE -
      RDESKTOP.OLB/LIBRARY/INCLUDE=(VMS_RDESKTOP) -
       ,VMS_RDESKTOP.OPT/OPT- !Link options file
          ! End of Link


!++
!  Create object library if it doesn't already exist
!--

.FIRST
	! MMS $(mmsqualifiers) $(mmstargets)
	IF F$SEARCH("VMS_RDESKTOP.H").NES."" then rename VMS_RDESKTOP.H RDESKTOP.H
	IF F$TRNLNM("X11").EQS."" THEN DEFINE X11 DECW$INCLUDE:
	IF F$TRNLNM("OPENSSL").EQS."" THEN DEFINE OPENSSL SSL$ROOT:[INCLUDE]
       IF F$SEARCH( "RDESKTOP.OLB" ) .EQS. "" THEN $(LIBR)/CREATE RDESKTOP.OLB

!++
!  End of build cleanup work
!--

.LAST
       CONTINUE

